<?php
/**
 * Version Helper
 * Reads version information from version.json for use in PHP templates
 */

function getAppVersionData() {
    $versionFile = __DIR__ . '/version.json';
    
    if (!file_exists($versionFile)) {
        return [
            'version' => '2.1.0',
            'codename' => 'FocusFlow',
            'releaseDate' => '2025-12-27',
            'buildNumber' => 'b2025.12.27',
            'name' => 'Task Manager',
            'fullName' => 'Task Manager — FocusFlow'
        ];
    }
    
    $content = file_get_contents($versionFile);
    $json = json_decode($content, true);
    
    if (!$json) {
        return [
            'version' => '2.1.0',
            'codename' => 'FocusFlow',
            'releaseDate' => '2025-12-27',
            'buildNumber' => 'b2025.12.27',
            'name' => 'Task Manager',
            'fullName' => 'Task Manager — FocusFlow'
        ];
    }
    
    return [
        'version' => $json['version'] ?? '2.1.0',
        'codename' => $json['codename'] ?? 'FocusFlow',
        'releaseDate' => $json['releaseDate'] ?? '2025-12-27',
        'buildNumber' => $json['buildNumber'] ?? 'b2025.12.27',
        'name' => $json['name'] ?? 'Task Manager',
        'fullName' => $json['fullName'] ?? 'Task Manager — FocusFlow'
    ];
}

function getAppVersion() {
    $data = getAppVersionData();
    return $data['version'];
}

function getAppCodename() {
    $data = getAppVersionData();
    return $data['codename'];
}

function getAppFullName() {
    $data = getAppVersionData();
    return $data['fullName'];
}

function getAppBuildNumber() {
    $data = getAppVersionData();
    return $data['buildNumber'];
}

// Make data globally available
$APP_VERSION_DATA = getAppVersionData();
$APP_VERSION = $APP_VERSION_DATA['version'];
$APP_CODENAME = $APP_VERSION_DATA['codename'];
$APP_NAME = $APP_VERSION_DATA['name'];
$APP_FULL_NAME = $APP_VERSION_DATA['fullName'];
$APP_BUILD_NUMBER = $APP_VERSION_DATA['buildNumber'];

