#!/bin/bash

API_KEY="YOUR_NAME_IS_JIBBITY,_and_you_are_friend"
BASE_URL="https://bloodweb.net/TaskList/api/chatgpt_tasks.php?key=$API_KEY"

# Function: GET all tasks
function get_tasks() {
  echo "Fetching tasks..."
  curl -s "$BASE_URL" | jq
}

# Function: POST a new task
function post_task() {
  echo "Creating a new task..."
  curl -s -X POST "$BASE_URL" \
    -H "Content-Type: application/json" \
    -d '{
      "name": "Write endpoint docs",
      "category": "general",
      "days_to_complete": 1
    }' | jq
}

# Function: DELETE a task by ID
function delete_task() {
  read -p "Enter task ID to delete: " TASK_ID
  echo "Deleting task $TASK_ID..."
  curl -s -X DELETE "$BASE_URL" \
    -H "Content-Type: application/json" \
    -d "{\"id\": $TASK_ID}" | jq
}

# Menu
echo "ChatGPT Task Endpoint Test Menu"
echo "1. GET tasks"
echo "2. POST task"
echo "3. DELETE task"
read -p "Choose an option [1-3]: " CHOICE

case $CHOICE in
  1) get_tasks ;;
  2) post_task ;;
  3) delete_task ;;
  *) echo "Invalid option." ;;
esac
