<?php
/**
 * Public Share Access Page
 * 
 * Allows anyone with a valid share token to view/edit a project
 * 
 * @author Jack Ewers / BloodWeb
 * @version 2.0.1
 * @date 2025-12-27
 */

// Start session using the same bootstrap as the main app
require_once $_SERVER['DOCUMENT_ROOT'] . '/auth/session_bootstrap.php';

// Get token from URL
$token = $_GET['token'] ?? null;

if (!$token) {
    header('Location: /TaskList/?error=invalid_token');
    exit;
}

// Validate token and get project data via API
$api_url = $_SERVER['REQUEST_SCHEME'] . '://' . $_SERVER['HTTP_HOST'] . '/app/tasklist/api/sharing.php?action=public_project&token=' . urlencode($token);
$ch = curl_init($api_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($http_code !== 200) {
    // Debug: log the error
    error_log("Shared link validation failed. Token: $token, HTTP Code: $http_code, Response: $response");
    header('Location: /TaskList/?error=invalid_or_expired_token');
    exit;
}

$project_data = json_decode($response, true);

if (!$project_data || !isset($project_data['id'])) {
    header('Location: /TaskList/?error=project_not_found');
    exit;
}

// Store token info in session for API access
$_SESSION['share_token'] = $token;
$_SESSION['share_permission'] = $project_data['permission_level'];
$_SESSION['share_project_id'] = $project_data['id'];
$_SESSION['share_project_name'] = $project_data['name'];

// Create a temporary "guest" marker in session if user not logged in
$is_logged_in = isset($_SESSION['user_id']);
if (!$is_logged_in) {
    $_SESSION['guest_user'] = true;
    $_SESSION['guest_project_id'] = $project_data['id'];
}

// Redirect to main app with share context
header('Location: /TaskList/?share_mode=1&project_id=' . $project_data['id']);
exit;
