# TaskList v2 - Advanced Task & Project Management System# 🧠 Torganise — Task Management System



**Version:** 2.0.0  **Torganise** is a high-definition task, project, and category manager built for self-hosting and future-proof team workflows. It features XP-based user progression, inline editing, and full keyboard and touchscreen support.

**Author:** Jack Ewers / BloodWeb  

**Last Updated:** November 18, 2025---



A feature-rich, gamified task management application with project organization, calendar integration, XP progression system, and achievement tracking.## 🚀 Features



---- 📁 Project, Category, and Task management views

- 🔀 Inline editing system (single active edit at a time)

## 🚀 Features- 🔄 Rehydration with `HTTP_modify` and optional arg `noRender`

- 🧹 Fast delete actions with a planned undo (trash buffer)

### Core Functionality- 📦 PWA-ready (manifest + service worker)

- **Task Management**: Create, edit, complete, and delete tasks with rich metadata- 💻 ChatGPT endpoint for read/write/delete task automation

- **Project Organization**: Group tasks into projects with custom colors and icons- 🌗 Automatic dark/light mode with planned manual override

- **Category System**: Organize tasks and projects by categories- 🧩 Modular structure with `createElement()` DOM abstraction

- **Priority Levels**: Low, Medium, High, Urgent (with visual indicators)- 🎨 Custom category color + emoji support

- **Complexity Tracking**: None, Simple, Moderate, Complex, Very Complex- 🧠 XP System (Planned: cosmetic unlocks and streak bonuses)

- **Due Date Management**: Set deadlines with quick duration presets (10, 30, 90 days)

- **Subtasks/Steps**: Break down tasks into manageable steps with progress tracking---



### Advanced Features## 📂 Directory Structure

- **Timeline Calendar**: Chronological view of upcoming events and task due dates

  - Date range filters (7, 14, 30, 90, 180 days)```bash

  - Integrated task and event displayTaskList/

  - Lazy loading for performance├── index.html               # Main webapp

- **Event Management**: Create calendar events with reminders, colors, and time ranges├── index.js                 # App initialization

- **XP & Leveling System**: Earn experience points for completing tasks├── AppManager.js            # Centralized state and DOM refs

  - Task complexity bonuses├── projects.js              # Project View logic

  - Project completion rewards├── categories.js            # Category View logic

  - Level progression tracking├── tasks.js                 # Task View logic

- **Achievement System**: Unlock achievements for milestones and patterns├── http.js                  # Backend fetch + modify

- **Smart Suggestions**: AI-powered category and due date recommendations├── ui.js                    # DOM rendering helpers

- **Bulk Operations**: Select and act on multiple tasks at once├── debug.js                 # Styled debugging with importancelevels

- **Search & Filters**: Find tasks by project, category, status, or keyword├── styles.css               # Unified CSS (light/dark modes)

├── manifest.json            # PWA manifest

### User Experience├── service-worker.js        # PWA service worker (no caching)

- **Dual-Mode Task Modal**:├── api/                     # PHP endpoint directory

  - **View Mode**: Clean, read-only display with Complete/Delete actions│   └── chatgpt_tasks.php

  - **Edit Mode**: Full editing interface with all fields├── php/                     # User system & DB logic

- **Responsive Design**: Optimized for desktop, tablet, and mobile│   └── users.php

- **Dark Mode Support**: Toggle between light and dark themes└── assets/                  # Icons, logos, and UI images

- **Onboarding**: Interactive tutorial for new users

- **Settings**: Customize defaults, last-used preferences, and behavior

- **Account Management**: Profile updates, avatar uploads, password changes```

## 🧠 Design Philosophy

---Torganise is built with clear UX principles and consistent structural rules in mind. All architectural and interaction decisions aim to support the following tenets:



## 📋 Architecture### 🔁 Unified Interaction Model

- **Single item edit mode** across all views (Tasks, Projects, Categories).

### Technology Stack- Consistent UI elements: `Add`, `Edit`, `Delete` always appear in the same order and behave similarly in each view.

- **Frontend**: Vanilla JavaScript (ES6+), CSS3, HTML5- Only one item can be in edit mode at any time, regardless of type.

- **Backend**: PHP 8.x with PDO (MySQL)

- **Database**: MySQL/MariaDB### ⚡ Fast & Snappy UX

- **PWA**: Service Worker for offline functionality- All operations (especially add/edit/delete) prioritize **low-latency feedback** and smooth transitions.

- **API**: RESTful JSON API- Actions feel immediate: placeholder effects, inline animations, and minimal full re-renders (`HTTP_modify(..., noRender: true)`).



### File Structure### 🔙 Built-In Extensibility

```- **Undo/Recall buffer** pattern is planned for all destructive operations.

tasklist/- Every deletion includes a `trash buffer placeholder` to support future undo functionality without major refactors.

├── index.php              # Main application entry point

├── main.js                # Core application logic (6600+ lines)### 🧩 Modular UI Components

├── styles.css             # Complete styling (7400+ lines)- All DOM elements are created via `createElement()` for maintainability and reusability.

├── service-worker.js      # PWA & caching (v13)- Styling is handled in `styles.css`, no inline styles (unless for rapid prototyping).

├── CalendarManager.js     # Timeline calendar management- Views use dedicated render functions (`renderTasksView()`, `renderCategoriesView()`, etc.), with rendering split into per-item functions (`createTaskElement()`, `createCategoryElements()`, etc.).

├── EventModal.js          # Event form handling

├── api/                   # PHP REST API endpoints### 🧪 Real-Time Binding Model

│   ├── tasks.php          # Task CRUD operations- Categories bind to Projects (and vice versa) using real-time UI updates.

│   ├── projects.php       # Project management- Updates are immediate, animated, and consistent across both views.

│   ├── categories.php     # Category operations- Project/category relationships are stored as arrays of IDs, not comma-separated strings.

│   ├── subtasks.php       # Subtask handling

│   ├── achievements.php   # Achievement tracking### 🎯 Precision Over Flexibility

│   ├── users.php          # User management- Bulk operations like multi-edit are intentionally avoided or postponed.

│   ├── xp.php            # XP & leveling- Each interaction is designed for clarity, not feature creep.

│   └── calendar/

│       └── events.php     # Calendar events API---

├── classes/               # PHP business logic

│   ├── Database.php       # Database connectionThis philosophy helps keep the system lean, predictable, and testable — and scales well with future features like XP systems, cosmetics, or mobile deployment.

│   ├── TaskManager.php    # Task operations
│   ├── ProjectManager.php # Project operations
│   └── XPManager.php      # XP calculations
└── uploads/              # User-uploaded files
```

### Database Schema
- **users**: User accounts and profiles
- **projects**: Project definitions with colors/icons
- **categories**: Task/project categories
- **tasks**: Main task data with metadata
- **subtasks**: Task steps/checklist items
- **user_xp**: XP tracking and level progression
- **achievements**: Achievement definitions
- **user_achievements**: Unlocked achievements per user
- **calendar_events**: Calendar events with reminders
- **user_settings**: User preferences and defaults

---

## 🎮 Gamification System

### XP Sources
- **Task Completion**: Base XP based on complexity
  - Simple: 10 XP
  - Moderate: 25 XP
  - Complex: 50 XP
  - Very Complex: 100 XP
- **Priority Bonus**: +50% for high priority, +100% for urgent
- **Subtasks Bonus**: +5 XP per completed subtask
- **Early Completion**: +20% if completed before due date
- **Project Completion**: Bonus XP for finishing all project tasks

### Achievement Categories
- **Task Milestones**: Complete 10, 50, 100, 500, 1000 tasks
- **Project Completion**: Finish 5, 25, 50, 100 projects
- **Streak Tracking**: Daily completion streaks
- **Speed Achievements**: Quick task completion
- **Efficiency**: Complete tasks ahead of schedule
- **Complexity Master**: Complete high-complexity tasks
- **Organization**: Create structured projects with subtasks

### Leveling System
- Level 1-100 progression
- XP requirements increase per level
- Visual progress bars in UI
- Profile display of current level

---

## 🎨 User Interface

### Views
1. **Dashboard**: Overview with stats, recent tasks, and XP progress
2. **Tasks**: Full task list with filters, search, and bulk actions
3. **Projects**: Project cards with task counts and completion status
4. **Calendar**: Timeline view of events and task due dates
5. **Settings**: User preferences and application defaults
6. **Account**: Profile management, avatar, password changes

### Modal System
- **Task Modal**: Dual-mode (view/edit) with smart form
- **Project Modal**: Project creation with color/icon picker
- **Event Modal**: Calendar event form with reminders
- **Achievement Modal**: Display unlocked achievements

### Design Elements
- **Color-Coded Projects**: Visual identification with custom colors
- **Priority Badges**: Color-coded urgency indicators
- **Progress Bars**: Visual completion tracking
- **Icons**: Font Awesome integration throughout
- **Animations**: Smooth transitions and micro-interactions
- **Empty States**: Friendly messages for empty views

---

## 🔧 Configuration

### Environment Variables
Set in `config.php`:
```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'tasklist_db');
define('DB_USER', 'your_username');
define('DB_PASS', 'your_password');
define('UPLOAD_PATH', __DIR__ . '/uploads/');
```

### Default Settings
Configurable in `main.js` CONFIG object:
```javascript
CONFIG = {
    DEFAULTS: {
        task: {
            dueDays: 30,
            priority: 'medium',
            complexity: 'none'
        },
        project: {
            color: '#2563eb',
            icon: 'fas fa-folder'
        }
    },
    XP: {
        complexityMultipliers: { /* ... */ },
        priorityMultipliers: { /* ... */ }
    }
}
```

### User Preferences
Stored per-user in database:
- Default due date offset
- Default priority level
- Use last project/category
- Theme preference
- View preferences

---

## 🚀 API Endpoints

### Tasks
- `GET /api/tasks.php` - List all tasks
- `GET /api/tasks.php?id={id}` - Get single task
- `POST /api/tasks.php` - Create task
- `PUT /api/tasks.php?id={id}` - Update task
- `DELETE /api/tasks.php?id={id}` - Delete task
- `PATCH /api/tasks.php?id={id}/complete` - Toggle completion

### Projects
- `GET /api/projects.php` - List all projects
- `POST /api/projects.php` - Create project
- `PUT /api/projects.php?id={id}` - Update project
- `DELETE /api/projects.php?id={id}` - Delete project
- `PATCH /api/projects.php?id={id}/toggle-completion` - Toggle completion

### Calendar Events
- `GET /api/calendar/events.php?start_date={date}&end_date={date}` - List events
- `GET /api/calendar/events.php?id={id}` - Get single event
- `POST /api/calendar/events.php` - Create event
- `PUT /api/calendar/{id}` - Update event
- `DELETE /api/calendar/{id}` - Delete event

### XP & Achievements
- `GET /api/xp.php` - Get user XP and level
- `GET /api/achievements.php` - Get user achievements
- `POST /api/tasks.php?id={id}/complete` - Awards XP on completion

---

## 🎯 Key Features Explained

### Timeline Calendar
The timeline replaces traditional month/week views with a chronological list:
- Combines events and task due dates in one view
- Filters for quick date range selection
- Lazy loads only visible date ranges
- Special styling for "Today" and overdue items
- Click tasks to view details, events to edit

### Task Modal Modes
**View Mode** (triggered from calendar/dashboard):
- Read-only display of task details
- Project badge with icon and color
- Category badge with styling
- Complete and Delete action buttons
- Edit button to switch to edit mode

**Edit Mode** (triggered from tasks tab):
- Full form with all fields
- Smart suggestions based on title/description
- Quick duration presets
- Subtask management
- Cancel and Save buttons

### Smart Suggestions
AI-powered recommendations while creating tasks:
- Category suggestions based on title keywords
- Due date recommendations based on task complexity
- Related task detection to avoid duplicates

### Bulk Operations
Select multiple tasks to:
- Mark all as complete
- Delete selected tasks
- Change priority/project in bulk
- Move to different project

---

## 🔐 Security

### Authentication
- Session-based authentication
- Password hashing with PHP password_hash()
- CSRF protection on forms
- Session timeout after inactivity

### Authorization
- User-scoped data (can only access own tasks)
- SQL injection prevention via PDO prepared statements
- XSS prevention with htmlspecialchars()
- File upload validation and sanitization

### Best Practices
- Input validation on client and server
- Error messages don't expose sensitive info
- Secure session configuration
- HTTPS recommended for production

---

## 📱 Progressive Web App

### Service Worker Features
- **Offline Support**: Core functionality works without internet
- **Cache Strategies**:
  - Network-first for API calls
  - Cache-first for static assets
- **Background Sync**: Queues actions when offline
- **Install Prompt**: Add to home screen on mobile
- **Cache Version**: v13 (auto-updates on new versions)

### Caching Behavior
- Static assets cached immediately on install
- API responses cached with 5-minute TTL
- User uploads excluded from cache
- Automatic cleanup of old cache versions

---

## 🐛 Known Issues & Limitations

### Current Limitations
- Single-user session (no concurrent sessions)
- No real-time collaboration
- Event reminders require page to be open
- File attachments not implemented for tasks
- No email notifications

### Future Enhancements
- Recurring events
- Task templates
- Time tracking
- Export/import (CSV, iCal)
- Email reminders
- Mobile apps (iOS/Android)
- Team collaboration features
- Kanban board view

---

## 📚 Development

### Getting Started
1. Clone repository
2. Set up MySQL database with provided schema
3. Configure `config.php` with database credentials
4. Ensure PHP 8.x with PDO MySQL extension
5. Point web server to tasklist directory
6. Navigate to `/index.php` to start

### Code Style
- JavaScript: ES6+, semicolons, camelCase
- PHP: PSR-12 coding standards
- CSS: BEM-inspired naming, CSS custom properties
- Comments: JSDoc for functions, inline for complex logic

### Browser Support
- Chrome/Edge: 90+
- Firefox: 88+
- Safari: 14+
- Mobile Safari: 14+
- No IE11 support (uses modern JS features)

### Performance
- Lazy loading for large datasets
- Debounced search input (300ms)
- Virtualized rendering for long lists
- Service worker caching
- Optimized database queries with indexes

---

## 📄 License

Copyright © 2025 BloodWeb / Jack Ewers

This software is proprietary and confidential. Unauthorized copying, distribution, or modification is strictly prohibited.

---

## 🤝 Support

For issues, questions, or feature requests:
- **Developer**: Jack Ewers
- **Organization**: BloodWeb
- **Contact**: Via BloodWeb platform

---

## 🎉 Acknowledgments

Built with dedication to productivity, organization, and the joy of completing tasks! 🚀

Special thanks to:
- Font Awesome for icons
- The open-source community
- All users providing feedback and ideas
