<?php
// users.php

// Include the database connection file
require_once $_SERVER['DOCUMENT_ROOT'] . '/PHP/GLOB_Connect_TM.php';

// Get the request method (POST, GET, etc.)
$request_method = $_SERVER["REQUEST_METHOD"];

switch ($request_method) {
    case 'POST':
        // Handle user registration and XP logging (based on 'action' in body)
        $data = json_decode(file_get_contents("php://input"), true);

        // Ensure action exists
        if (!isset($data['action'])) {
            echo json_encode(['error' => 'No action specified']);
            exit;
        }

        switch ($data['action']) {
            case 'register':
                handleRegistration($data);
                break;
            case 'login':
                handleLogin($data);
                break;
            case 'log_xp':
                handleXPLog($data);
                break;
            default:
                echo json_encode(['error' => 'Invalid action']);
                exit;
        }
        break;

    default:
        echo json_encode(['error' => 'Unsupported request method']);
        break;
}

// Handle user registration
function handleRegistration($data) {
    $username = trim($data['username'] ?? '');
    $password = $data['password'] ?? '';
    $email = trim($data['email'] ?? '');
    $display_name = trim($data['display_name'] ?? '');

    if (!$username || !$password || !$email) {
        echo json_encode(['error' => 'Missing required fields']);
        return;
    }

    $password_hash = password_hash($password, PASSWORD_BCRYPT);

    // Insert user into database
    $stmt = $pdo->prepare("INSERT INTO users (username, password_hash, email, display_name) VALUES (?, ?, ?, ?)");
    
    try {
        $stmt->execute([$username, $password_hash, $email, $display_name]);
        echo json_encode(['success' => true, 'message' => 'User created']);
    } catch (PDOException $e) {
        echo json_encode(['error' => 'User creation failed', 'details' => $e->getMessage()]);
    }
}

// Handle user login
function handleLogin($data) {
    $username = trim($data['username'] ?? '');
    $password = $data['password'] ?? '';

    // Fetch user from DB
    $stmt = $pdo->prepare("SELECT id, password_hash FROM users WHERE username = ?");
    $stmt->execute([$username]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user && password_verify($password, $user['password_hash'])) {
        echo json_encode(['success' => true, 'user_id' => $user['id']]);
    } else {
        echo json_encode(['error' => 'Invalid login']);
    }
}

// Handle XP logging
function handleXPLog($data) {
    $user_id = intval($data['user_id'] ?? 0);
    $action = trim($data['action'] ?? '');
    $xp = intval($data['xp'] ?? 0);

    if ($user_id <= 0 || !$action || $xp <= 0) {
        echo json_encode(['error' => 'Invalid XP log data']);
        return;
    }

    $stmt = $pdo->prepare("INSERT INTO xp_log (user_id, action, xp) VALUES (?, ?, ?)");
    $stmt->execute([$user_id, $action, $xp]);

    echo json_encode(['success' => true]);
}
