#!/bin/bash

# ============================================================================
# FILE: watch-stamp.sh
# PURPOSE: Watch JS files and update LAST UPDATED stamp on save
# AUTHOR: Jack Ewers / bloodweb.net
# LAST UPDATED: 2025-05-07
# ============================================================================

WATCH_DIR="."
EXTENSION="js"
DATE=$(date +%F)

echo "🛠 Watching for changes in *.$EXTENSION files under $WATCH_DIR"
echo "🔄 Auto-updating LAST UPDATED timestamp to: $DATE"
echo "⏳ Press [CTRL+C] to stop..."

inotifywait -mrq -e close_write --exclude '(\.min\.js|node_modules|vendor)' "$WATCH_DIR" --format '%w%f' |
while read -r FILE; do
    if [[ "$FILE" == *.$EXTENSION ]]; then
        echo "📝 Updating: $FILE"


        # Replace the line starting with LAST UPDATED
        #sed -i "s/^\/\/ LAST UPDATED:.*/\/\/ LAST UPDATED: $DATE/" "$FILE"
        sleep 0.1
        sed -i "s|^[[:space:]]*// LAST UPDATED:.*|// LAST UPDATED: $DATE|" "$FILE"
        

    fi
done
