<?php
// Set the response content type to JSON
header('Content-Type: application/json');

// Allow all origins for CORS
header('Access-Control-Allow-Origin: *');

// Allow specific methods (Note: POST is the primary method for handling custom methods)
header('Access-Control-Allow-Methods: POST, GET, FETCH, OPTIONS');

// Allow specific headers
header('Access-Control-Allow-Headers: Content-Type, Authorization');

// Enable error reporting (for debugging)
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

// Include the database connection file
require_once $_SERVER['DOCUMENT_ROOT'] . '/PHP/GLOB_Connect_TM.php';

// Get the raw POST data
$input = file_get_contents('php://input');
$data = json_decode($input, true);
 
// Extract the custom 'method' from the JSON data
$method = $data['method'] ?? null;  // If method is not provided, default to null

if (!$method) {
    echo json_encode(['success' => false, 'error' => 'No method specified']);
    exit();
}
 
// Check the request method and call the appropriate SQL function

// ╔═══════════════════════════════════════════════════════════════════════════╗
// ║      Task Manager OVERVIEW                                           ║
// ║                                                                            ║
// ║      1.    TASKS 
// ║      2.    CATEGORIES
// ║      3.    PROJECTS
// ║         x.1  GET METHOD     - Request data in JSON from database                                                                  ║
// ║         x.1  ADD METHOD     - ADD into database                                                                  ║
// ║         x.2  EDIT METHOD    - CHANGE arg1(column_name) to arg2(value)                                                                   ║
// ║         x.3  DELETE METHOD  - DELETE item(s) from the database                                                                 ║
// ║                                                                            ║
// ║                                                                            ║
// ╚═══════════════════════════════════════════════════════════════════════════╝

switch ($method) {

// ╔═══════════════════════════════════════════════════════════════════════════╗
// ║                               Task Functions                              ║
// ╚═══════════════════════════════════════════════════════════════════════════╝
    
    case 'GET_TASKS': // default get pulls all tasks
        get_tasks();
    break;

    case 'ADD_TASKS':
        add_tasks($data);
    break;

    case 'EDIT_TASKS':
        edit_tasks($data);
    break;

    case 'DELETE_TASKS':
        delete_tasks($data);
    break;

// ╔═══════════════════════════════════════════════════════════════════════════╗
// ║                             Category Functions                            ║
// ╚═══════════════════════════════════════════════════════════════════════════╝
    
    case 'GET_CATEGORIES':
        get_categories();
    break;

    case 'ADD_CATEGORIES':
        add_categories($data);
    break;
    
    case 'EDIT_CATEGORIES':
        edit_categories($data);
    break;
    
    case 'DELETE_CATEGORIES':
        delete_categories($data);
    break;

// ╔═══════════════════════════════════════════════════════════════════════════╗
// ║                              Project Functions                            ║
// ╚═══════════════════════════════════════════════════════════════════════════╝

    case 'GET_PROJECTS':
        get_projects();
    break;

    case 'ADD_PROJECTS':
        add_projects($data);
    break;

    case 'EDIT_PROJECTS':
        edit_projects($data);
    break;

    case 'DELETE_PROJECTS':
        delete_projects($data);
    break;
    
// ╔═══════════════════════════════════════════════════════════════════════════╗
// ║                              USER AUTH / XP                               ║
// ╚═══════════════════════════════════════════════════════════════════════════╝
    case 'REGISTER_USER':
        handleRegistration($data);
    break;
    
    case 'LOGIN_USER':
        handleLogin($data);
    break;
    
    case 'LOG_XP':
        handleXPLog($data);
    break;
    
    // Add more cases for other methods (PUT, etc.) as needed
    default:
        echo json_encode(array("error" => "Unsupported request method. Does the server support this method? Check case statement."));
    break;    
    }



// ╔═══════════════════════════════════════════════════════════════════════════╗
// ║                                Functions                                  ║
// ║                                                                           ║
// ║               1. Tasks                                                    ║
// ║               2. Categories                                                ║
// ║               3. Projects                                                 ║
// ║                                                                           ║
// ║               4. User Registration                                         ║
// ║               5. User Login                                               ║
// ║               6. XP Logging                                               ║
// ╚═══════════════════════════════════════════════════════════════════════════╝


// ╔═══════════════════════════════════════════════════════════════════════════╗
// ║            1.TASKS                                                          ║
// ╚═══════════════════════════════════════════════════════════════════════════╝

function get_tasks() {
    $sql = "SELECT * FROM tasks";
    $result = mysqli_query($GLOBALS["connection"], $sql);

    if ($result) {
        $tasks = array();
        while ($row = mysqli_fetch_assoc($result)) {
            $tasks[] = $row;
        }
        echo json_encode($tasks);
    } else {
        echo json_encode(array("error" => "Query failed: " . $GLOBALS["connection"]->error));
    }
}

function add_tasks($data) {
       // Check if all required data fields are set
       if (isset(
            $data['name'], 
            $data['description'],
            $data['days_to_complete'], 
            $data['upload_date'], 
            $data['category'], 
            $data['project'])) {
        // Sanitize and assign the input data
        $name = mysqli_real_escape_string($GLOBALS["connection"], $data['name']);
        $description = mysqli_real_escape_string($GLOBALS["connection"], $data['description']);
        $days_to_complete = (int)$data['days_to_complete'];
        $upload_date = mysqli_real_escape_string($GLOBALS["connection"], $data['upload_date']);
        $category = mysqli_real_escape_string($GLOBALS["connection"], $data['category']);
        $project = mysqli_real_escape_string($GLOBALS["connection"], $data['project']);
        
        // Prepare the SQL query
        $sql = "INSERT INTO tasks (name, description, days_to_complete, upload_date, category, project) VALUES ('$name', '$description', $days_to_complete, '$upload_date', '$category', '$project')";

        // Execute the query and check for success
        if (mysqli_query($GLOBALS["connection"], $sql)) {
            echo json_encode(array("success" => "Task added successfully"));
        } else {
            echo json_encode(array("error" => "Query failed: " . $GLOBALS["connection"]->error));
        }
    } else {
        function get_data_with_types($data) {
            $result = array();
            foreach ($data as $key => $value) {
                $result[] = "$key: " . gettype($value) . " (" . json_encode($value) . ")";
            }
            return implode(", ", $result);
        }

        $error_message = "Add Task Invalid input data: " . get_data_with_types($data);
        echo json_encode(array("error" => $error_message));
    }
}
function edit_tasks($data) {
    // Handle PUT request (Edit task)
    if (isset($data['id'], $data['name'], $data['days_to_complete'], $data['upload_date'], $data['category'],$data['project'])) {
        $id = (int)$data['id'];
        $name = mysqli_real_escape_string($GLOBALS["connection"], $data['name']);
        $days_to_complete = (int)$data['days_to_complete'];
        $upload_date = mysqli_real_escape_string($GLOBALS["connection"], $data['upload_date']);
        $category = mysqli_real_escape_string($GLOBALS["connection"], $data['category']);

        $sql = "UPDATE tasks SET name='$name', days_to_complete=$days_to_complete, upload_date='$upload_date', category='$category', project='$project' WHERE id=$id";

        if (mysqli_query($GLOBALS["connection"], $sql)) {
            echo json_encode(array("success" => "Task updated successfully"));
        } else {
            echo json_encode(array("error" => "Query failed: " . $GLOBALS["connection"]->error));
        }
    } else {
        echo json_encode(array("error" => "Invalid input data"));
    }
}
function delete_tasks($data) {
            if (isset($data['ids']) && is_array($data['ids'])) {
                $ids = array_filter($data['ids'], 'is_numeric');
                if (!empty($ids)) {
                    $ids_string = implode(',', $ids);
                    $sql = "DELETE FROM tasks WHERE id IN ($ids_string)";

                    if (mysqli_query($GLOBALS["connection"], $sql)) {
                        echo json_encode(array("success" => "Tasks deleted successfully"));
                    } else {
                        echo json_encode(array("error" => "Query failed: " . $GLOBALS["connection"]->error));
                    }
                } else {
                    echo json_encode(array("error" => "Invalid IDs provided"));
                }
            } else {
                echo json_encode(array("error" => "Invalid input data"));
            }
        }
        
// ╔═══════════════════════════════════════════════════════════════════════════╗
// ║            2.CATEGORIES                                                   ║
// ╚═══════════════════════════════════════════════════════════════════════════╝
function get_categories() {
    // Handle GET request (Fetch categories)
    $sql = "SELECT * FROM categories";
    $result = mysqli_query($GLOBALS["connection"], $sql);

    if ($result) {
        $categories = array();
        while ($row = mysqli_fetch_assoc($result)) {
            $row['projectIDs'] = array_filter(array_map('intval', explode(',', $row['projectIDs'] ?? '')));
            $categories[] = $row;
        }
        echo json_encode($categories);
    } else {
        echo json_encode(array("error" => "Query failed: " . $GLOBALS["connection"]->error));
}
}

function add_categories($data) {
    // Handle POST request (Add category)
    if (isset($data['name'])) {
        $category = mysqli_real_escape_string($GLOBALS["connection"], $data['name']);
        $color = mysqli_real_escape_string($GLOBALS["connection"], $data['color']);
        $emoji = mysqli_real_escape_string($GLOBALS["connection"], $data['emoji'])  ;
        $projectIDs = mysqli_real_escape_string($GLOBALS["connection"], $data['projectIDs']);
        $sql = "INSERT INTO categories (name, color, emoji, projectIDs) VALUES ('$category','$color','$emoji','$projectIDs')";

        if (mysqli_query($GLOBALS["connection"], $sql)) {
            echo json_encode(array("success" => "Category added successfully"));
        } else {
            echo json_encode(array("error" => "Query failed: " . $GLOBALS["connection"]->error));
        }
    } else {
        echo json_encode(array("error" => "Invalid input data"));
    }
}
function edit_categories($data) {
    // Handle PUT request (Edit category)
    if (isset($data['id'], $data['name'], $data['color'], $data['emoji'], $data['projectIDs'])) {
        $id = (int)$data['id'];
        $name = mysqli_real_escape_string($GLOBALS["connection"], $data['name']);
        $color = mysqli_real_escape_string($GLOBALS["connection"], $data['color']);
        $emoji = mysqli_real_escape_string($GLOBALS["connection"], $data['emoji']);
        $projectIDs = mysqli_real_escape_string($GLOBALS["connection"], $data['projectIDs']);

        $sql = "UPDATE categories SET name='$name', color='$color', emoji='$emoji', projectIDs='$projectIDs' WHERE id=$id";

        if (mysqli_query($GLOBALS["connection"], $sql)) {
            echo json_encode(array("success" => "Category updated successfully"));
        } else {
            echo json_encode(array("error" => "Query failed: " . $GLOBALS["connection"]->error));
        }
    } else {
        echo json_encode(array("error" => "Invalid input data"));
    }
}
function delete_categories($data) {
    // Handle DELETE request (Delete category)
    if (isset($data['ids'])) {
        // Check if 'ids' is an array
        if (is_array($data['ids'])) {
            $ids = array_filter($data['ids'], 'is_numeric');
            if (!empty($ids)) {
                $ids_string = implode(',', $ids);
                $sql = "DELETE FROM categories WHERE id IN ($ids_string)";
            } else { 
                echo json_encode(array("error" => "Invalid IDs provided " . $data['ids']->error));
                return;
            }
        } else {
            // If 'ids' is not an array, treat it as a single ID
            $id = (int)$data['ids'];
            $sql = "DELETE FROM categories WHERE id=$id";
        }

        if (mysqli_query($GLOBALS["connection"], $sql)) {
            echo json_encode(array("success" => "Category deleted successfully"));
        } else {
            echo json_encode(array("error" => "Query failed: " . $GLOBALS["connection"]->error));
        }
    } else {
        echo json_encode(array("error" => "Invalid input data"));
    }
}   
// ╔═══════════════════════════════════════════════════════════════════════════╗
// ║    3.#PROJECTS                                                             ║
// ║                                                                           ║
// ║       . get_projects                                                                    ║
// ║       . add_projects                                                      ║              
// ║       . deleter_projects                                                  ║                  
// ╚═══════════════════════════════════════════════════════════════════════════╝
function get_projects() {
    $sql = "SELECT * FROM projects";
    $result = mysqli_query($GLOBALS["connection"], $sql);

    if ($result) {
        $projects = array();
        while ($row = mysqli_fetch_assoc($result)) { 
            $row['categoryIDs'] = array_filter(array_map('intval', explode(',', $row['categoryIDs'] ?? '')));
            $projects[] = $row; 
        }
        echo json_encode($projects);
    } else {
        echo json_encode(array("error" => "Query failed: " . $GLOBALS["connection"]->error));
    }
}
function edit_projects($data) {
    if (isset($data['id'], $data['name'], $data['categoryIDs'])) {
        $id = (int)$data['id'];
        $name = mysqli_real_escape_string($GLOBALS["connection"], $data['name']);
        $categoryIDs = mysqli_real_escape_string($GLOBALS["connection"], $data['categoryIDs']);
        $sql = "UPDATE projects SET name='$name', categoryIDs='$categoryIDs' WHERE id=$id";

        if (mysqli_query($GLOBALS["connection"], $sql)) { echo json_encode(array("success" => "Project updated successfully")); } 
        else { echo json_encode(array("error" => "Query failed: " . $GLOBALS["connection"]->error)); }
    } else {
        echo json_encode(array("error" => "Invalid input data"));
    }
}
function add_projects($data) {
    // Handle POST request (Add project)
    if (isset($data['name'])) {
        $project = mysqli_real_escape_string($GLOBALS["connection"], $data['name']);      
        $sql = "INSERT INTO projects (name) VALUES ('$project')";
        if (mysqli_query($GLOBALS["connection"], $sql)) {
            echo json_encode(array("success" => "Project added successfully"));
        } else {
            echo json_encode(array("error" => "Category ADD failed: " . $GLOBALS["connection"]->error));
        }
    } else {
        echo json_encode(array("error" => "Invalid input data"));
    }
}

function delete_projects($data) {
    if (isset($data['id'])) {
        $id = (int)$data['id'];
        $sql = "DELETE FROM projects WHERE id = $id";

        if (mysqli_query($GLOBALS["connection"], $sql)) {
            echo json_encode(array("success" => "Project deleted successfully"));
        } else {
            echo json_encode(array("error" => "Query failed: " . $GLOBALS["connection"]->error));
        }
    } else {
        echo json_encode(array("error" => "Invalid input data"));
    }
}
// ╔═══════════════════════════════════════════════════════════════════════════╗
// ║            4.USER REGISTRATION                                                   ║
// ╚═══════════════════════════════════════════════════════════════════════════╝

function handleRegistration($data) {
    if (isset($data['username'], $data['password'], $data['email'], $data['display_name'])) {
        $username = mysqli_real_escape_string($GLOBALS["connection"], $data['username']);
        $email = mysqli_real_escape_string($GLOBALS["connection"], $data['email']);
        $first_name = mysqli_real_escape_string($GLOBALS["connection"], $data['first_name']);
        $last_name  = mysqli_real_escape_string($GLOBALS["connection"], $data['last_name']);

        $password_hash = password_hash($data['password'], PASSWORD_BCRYPT);

        $sql = "INSERT INTO users (username, password_hash, email, first_name, last_name)
                VALUES ('$username', '$password_hash', '$email', '$first_name', '$last_name')";

        if (mysqli_query($GLOBALS["connection"], $sql)) {
            echo json_encode(["success" => "User created successfully"]);
        } else {
            echo json_encode(["error" => "Failed to create user: " . mysqli_error($GLOBALS["connection"])]);
        }
    } else {
        echo json_encode(["error" => "Missing fields"]);
    }
}

// ╔═══════════════════════════════════════════════════════════════════════════╗
// ║            4.USER REGISTRATION                                                   ║
// ╚═══════════════════════════════════════════════════════════════════════════╝

function handleLogin($data) {
    if (isset($data['email'], $data['password'])) {
        $usernameOrEmail = mysqli_real_escape_string($GLOBALS["connection"], $data['email']);
        $password = $data['password'];

        $sql = "SELECT id, password_hash FROM users 
        WHERE username = '$usernameOrEmail' OR email = '$usernameOrEmail'";

        $result = mysqli_query($GLOBALS["connection"], $sql);

        if ($result && mysqli_num_rows($result) === 1) {
            $user = mysqli_fetch_assoc($result);
            if (password_verify($password, $user['password_hash'])) {
                echo json_encode(["success" => true, "user_id" => $user['id']]);
            } else {
                echo json_encode(["error" => "Invalid password"]);
            }
        } else {
            echo json_encode(["error" => "User not found"]);
        }
    } else {
        echo json_encode(["error" => "Missing username or password"]);
    }
}

// ╔═══════════════════════════════════════════════════════════════════════════╗
// ║            6.XP LOGGING                                                  ║
// ╚═══════════════════════════════════════════════════════════════════════════╝

function handleXPLog($data) {
    $user_id = intval($data['user_id'] ?? 0);
    $action = trim($data['action'] ?? '');
    $xp = intval($data['xp'] ?? 0);

    if ($user_id <= 0 || !$action || $xp <= 0) {
        echo json_encode(['error' => 'Invalid XP log data']);
        return;
    }

    $stmt = $pdo->prepare("INSERT INTO xp_log (user_id, action, xp) VALUES (?, ?, ?)");
    $stmt->execute([$user_id, $action, $xp]);

    echo json_encode(['success' => true]);
}

// Close the connection
$GLOBALS["connection"]->close();
?>