-- Create database if it does not exist
CREATE DATABASE IF NOT EXISTS task_manager;
USE task_manager;

-- Create tasks table if it does not exist
CREATE TABLE IF NOT EXISTS tasks (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(255) NOT NULL,
    days_to_complete INT NOT NULL DEFAULT 30,
    upload_date DATE NOT NULL DEFAULT CURRENT_DATE,
    category VARCHAR(255) NOT NULL DEFAULT 'misc',
    weight INT NOT NULL DEFAULT 2
    project_id INT;
);

-- Create recurring_tasks table if it does not exist
CREATE TABLE IF NOT EXISTS recurring_tasks (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(255) NOT NULL,
    recurrence INT NOT NULL DEFAULT 7,
    last_completed DATE NOT NULL DEFAULT CURRENT_DATE,
    days_till_next INT NOT NULL DEFAULT 7,
    completions INT NOT NULL DEFAULT 0,
    category VARCHAR(255) NOT NULL DEFAULT 'misc',
    weight INT NOT NULL DEFAULT 1
 );

-- Create archived_tasks table if it does not exist
CREATE TABLE IF NOT EXISTS archived_tasks (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(255) NOT NULL,
    days_to_complete INT NOT NULL,
    date_completed DATE NOT NULL DEFAULT CURRENT_DATE,
    category VARCHAR(255) NOT NULL DEFAULT 'misc',
    weight INT NOT NULL DEFAULT 1
);

-- Create projects table if it does not exist
CREATE TABLE IF NOT EXISTS projects (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(255) NOT NULL,
    categories VARCHAR(255) -- CSV field for categories
);