<?php
// Quick script to fix table names in Models.php

$file = '/var/www/html/bloodweb/app/tasklist/v2/api/Models.php';
$content = file_get_contents($file);

// Replace table property definitions
$content = str_replace("protected \$table = 'users';", "protected \$table = 'users_v2';", $content);
$content = str_replace("protected \$table = 'categories';", "protected \$table = 'categories_v2';", $content);
$content = str_replace("protected \$table = 'tasks';", "protected \$table = 'tasks_v2';", $content);

// Replace explicit table names in queries
$content = str_replace("FROM projects p", "FROM projects_v2 p", $content);
$content = str_replace("FROM categories c", "FROM categories_v2 c", $content);
$content = str_replace("FROM tasks t", "FROM tasks_v2 t", $content);

// Replace table names in other SQL statements
$content = str_replace("project_categories", "project_categories_v2", $content);
$content = str_replace("INNER JOIN projects p", "INNER JOIN projects_v2 p", $content);
$content = str_replace("INNER JOIN categories c", "INNER JOIN categories_v2 c", $content);
$content = str_replace("INNER JOIN tasks t", "INNER JOIN tasks_v2 t", $content);

file_put_contents($file, $content);
echo "Table names updated successfully!\n";
?>