-- Migration: Create calendar_events table
-- Date: 2025-11-17
-- Description: Calendar events with task linking and recurrence support

CREATE TABLE IF NOT EXISTS calendar_events (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    title VARCHAR(255) NOT NULL,
    description TEXT,
    event_date DATE NOT NULL,
    event_time TIME,
    end_time TIME,
    is_all_day BOOLEAN DEFAULT 0,
    location VARCHAR(255),
    color VARCHAR(7) DEFAULT '#3b82f6',
    reminder_minutes INT DEFAULT NULL COMMENT 'Minutes before event to remind (NULL = no reminder)',
    recurrence_rule VARCHAR(255) DEFAULT NULL COMMENT 'RRULE format for recurring events',
    task_id INT DEFAULT NULL COMMENT 'Optional link to tasks table',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    
    -- Indexes
    INDEX idx_user_id (user_id),
    INDEX idx_event_date (event_date),
    INDEX idx_task_id (task_id),
    INDEX idx_user_date (user_id, event_date),
    
    -- Foreign keys
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
    FOREIGN KEY (task_id) REFERENCES tasks(id) ON DELETE SET NULL,
    
    -- Additional composite index for date range queries
    INDEX idx_date_range (user_id, event_date, event_time)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
