<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/auth/session_bootstrap.php';
require_once $_SERVER['DOCUMENT_ROOT'] . '/auth/session_guard.php';
require_once __DIR__ . '/version.php';


// Check if this is a guest user with share token access
$is_guest_user = isset($_SESSION['guest_user']) && $_SESSION['guest_user'] === true;
$is_share_mode = isset($_GET['share_mode']) || isset($_SESSION['share_token']);
$share_project_id = $_SESSION['share_project_id'] ?? null;
$share_permission = $_SESSION['share_permission'] ?? 'view';
$share_project_name = $_SESSION['share_project_name'] ?? 'Shared Project';

// For guest users, create a temporary user context
if ($is_guest_user) {
    $user_id = -1; // Special ID for guests
    $user = [
        'id' => -1,
        'username' => 'guest',
        'first_name' => 'Guest',
        'last_name' => 'User',
        'email' => null,
        'avatar_url' => '/media/images/useruploads/default_avatar.png'
    ];
} else {
    // Regular authenticated user
    $user_id = AUTH_USER_ID;
    $user = AUTH_USER;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($APP_FULL_NAME); ?></title>
    <meta name="description" content="Modern task management with gamification, focus modes, and collaboration">
    
    <!-- Preload critical resources -->
    <link rel="preload" href="./styles.css?v=<?php echo time(); ?>" as="style">
    <link rel="preload" href="./main.js?v=<?php echo time(); ?>" as="script">
    <link rel="preload" href="/mediauseruploads/default_avatar.png" as="image">
    
    <!-- PWA Manifest -->
    <link rel="manifest" href="./manifest.json">
    <meta name="theme-color" content="#2563eb">
    <meta name="mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    
    <!-- BloodWeb User Theme Support -->
    <meta name="bw-user-id" content="<?php echo $user_id; ?>">
    <script src="/shared/assets/early-theme.js"></script>
    
    <!-- Styles -->
    <link rel="stylesheet" href="./styles.css?v=<?php echo time(); ?>">
    <script src="/shared/assets/early-theme.js"></script>

    <!-- Styles -->
    <link rel="stylesheet" href="./styles.css?v=<?php echo time(); ?>">
    <meta name="theme-color" content="#2563eb">
    <meta name="mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="default">
    
    <!-- Styles -->
    <link rel="stylesheet" href="./styles.css?v=<?php echo time(); ?>">
    <link rel="stylesheet" href="./share-modal-redesign.css?v=<?php echo time(); ?>">
    
    <!-- Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body data-share-mode="<?= $is_share_mode ? '1' : '0' ?>" data-share-permission="<?= htmlspecialchars($share_permission) ?>" data-share-project-id="<?= $share_project_id ?>">
    <div id="app" class="app">
        <!-- Loading Screen -->
        <div id="loading-screen" class="loading-screen">
            <div class="loading-content">
                <img src="/media/images/bloodweb/task_manager/TM_icon.png" alt="TaskList Logo" class="loading-logo">
                <div class="loading-spinner"></div>
                <div class="loading-text">
                    <h2>Loading <?php echo htmlspecialchars($APP_NAME); ?>
                        <br>
                        Version <?php echo htmlspecialchars($APP_VERSION); ?>
                        <br>
                        <?php echo htmlspecialchars($APP_CODENAME); ?>...</h2>
                    <p id="loading-status">Initializing...</p>
                </div>
            </div>
        </div>

        <?php if ($is_guest_user): ?>
        <!-- Guest User / Share Mode Banner -->
        <div class="share-mode-banner">
            <div class="share-banner-content">
                <div class="share-banner-info">
                    <i class="fas fa-share-alt"></i>
                    <div class="share-banner-text">
                        <strong>🎭 <?= $share_permission === 'edit' ? 'Project Collaborator' : 'Project Observer' ?></strong>
                        <span style="font-size: 0.9em; opacity: 0.9;">Viewing: <?= htmlspecialchars($share_project_name) ?></span>
                        <span class="share-permission-badge <?= $share_permission ?>">
                            <i class="fas fa-<?= $share_permission === 'edit' ? 'handshake' : 'binoculars' ?>"></i>
                            <?= $share_permission === 'edit' ? 'Can Edit Tasks' : 'View Only' ?>
                        </span>
                    </div>
                </div>
                <a href="/auth/login.php?redirect=<?= urlencode($_SERVER['REQUEST_URI']) ?>" class="btn btn-sm btn-primary">
                    <i class="fas fa-sign-in-alt"></i> Login to Save Your Work
                </a>
            </div>
        </div>
        <?php endif; ?>

        <!-- Offline Banner -->
        <div id="offline-banner" class="offline-banner" style="display: none;">
            <i class="fas fa-wifi-slash"></i>
            <span>You're offline. Changes will sync when you reconnect.</span>
        </div>

        <!-- Error Boundary -->
        <div id="error-boundary" class="error-boundary" style="display: none;">
            <div class="error-content">
                <i class="fas fa-exclamation-triangle"></i>
                <h2>Application Error</h2>
                <p>Something went wrong. Please try refreshing the page.</p>
                <button onclick="window.location.reload()" class="btn btn-primary">
                    <i class="fas fa-refresh"></i> Reload Page
                </button>
            </div>
        </div>

        <!-- Main App Layout -->
        <div class="app-layout">
            <!-- Header -->
            <header class="app-header">
                <div class="header-left">
                    <button id="sidebar-toggle" class="sidebar-toggle" aria-label="Toggle Sidebar">
                        <i class="fas fa-bars"></i>
                    </button>
                    <div class="brand">
                        <div class="brand-logo"><img src="/media/images/bloodweb/task_manager/TM_icon.png" alt="TaskList Logo"></div>
                        <h1 class="brand-title">TaskManager <span class="version" id="version-badge" role="button" tabindex="0" title="View changelog">v<?php echo htmlspecialchars($APP_VERSION); ?></span></h1>
                    </div>
                </div>
                
                <div class="header-center">
                    <div class="search-container">
                        <input type="text" id="global-search" placeholder="Search tasks, projects... (Press / to focus)" class="search-input" autocomplete="off">
                        <i class="fas fa-search search-icon"></i>
                        <div id="search-results" class="search-results" style="display: none;"></div>
                    </div>
                </div>
                
                <div class="header-right">
                    <div class="user-profile" id="user-profile">
                        <?php if ($is_guest_user): ?>
                            <!-- Guest User Layout -->
                            <div class="user-avatar" id="user-avatar"><?php echo $share_permission === 'edit' ? '🤝' : '👀'; ?></div>
                            <div class="user-info">
                                <div class="user-name"><?php echo $share_permission === 'edit' ? 'Project Collaborator' : 'Project Observer'; ?></div>
                            </div>
                        <?php else: ?>
                            <!-- Authenticated User Layout: 1. Avatar | 2. Name | 3. Level/XP | 4. Toggle -->
                            <div class="user-avatar" id="user-avatar"><?php echo substr($user['first_name'] ?? 'U', 0, 1); ?></div>
                            <div class="user-info">
                                <div class="user-name"><?php 
                                    $firstName = htmlspecialchars($user['first_name'] ?? 'User');
                                    $lastInitial = isset($user['last_name']) ? strtoupper(substr($user['last_name'], 0, 1)) . '.' : '';
                                    echo $firstName . ' ' . $lastInitial;
                                ?></div>
                            </div>
                            <div class="user-stats">
                                <div class="xp-display" id="xp-display">
                                    <span class="level-star">
                                        <i class="fas fa-star"></i>
                                        <span class="level-number" id="user-level">1</span>
                                    </span>
                                    <span class="xp-amount-display"><span id="xp-amount">0</span> XP</span>
                                </div>
                            </div>
                        <?php endif; ?>
                        <button class="user-menu-toggle" id="user-menu-toggle" title="User menu">
                            <i class="fas fa-chevron-down"></i>
                        </button>
                        <div class="user-dropdown-menu" id="user-dropdown-menu">
                            <?php if ($is_guest_user): ?>
                            <a href="/auth/login.php" class="user-menu-item">
                                <i class="fas fa-sign-in-alt"></i>
                                <span>Login</span>
                            </a>
                            <?php else: ?>
                            <a href="/account/" class="user-menu-item">
                                <i class="fas fa-user"></i>
                                <span>Account</span>
                            </a>
                            <a href="#" class="user-menu-item" id="settings-menu-item">
                                <i class="fas fa-cog"></i>
                                <span>Settings</span>
                            </a>
                            <a href="#" class="user-menu-item" id="logout-menu-item">
                                <i class="fas fa-sign-out-alt"></i>
                                <span>Logout</span>
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </header>

            <div class="app-body">
                <!-- Sidebar -->
                <aside class="sidebar" id="sidebar">
                    <nav class="sidebar-nav">
                        <!-- Core Section -->
                        <div class="nav-section">
                            <div class="nav-section-label">Core</div>
                            <ul class="nav-list">
                                <li class="nav-item">
                                    <a href="#" class="nav-link active" data-view="dashboard">
                                        <i class="fas fa-home"></i>
                                        <span>Dashboard</span>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="#" class="nav-link <?= $is_guest_user ? 'nav-link-disabled' : '' ?>" data-view="focus" <?= $is_guest_user ? 'data-guest-restricted="true"' : '' ?>>
                                        <i class="fas fa-bullseye"></i>
                                        <span>Focus</span>
                                        <?php if ($is_guest_user): ?>
                                            <span class="nav-user-badge">[user]</span>
                                        <?php else: ?>
                                            <span class="badge badge-fire">🔥</span>
                                        <?php endif; ?>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="#" class="nav-link" data-view="tasks">
                                        <i class="fas fa-tasks"></i>
                                        <span>Tasks</span>
                                        <span class="badge" id="active-tasks-count">0</span>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="#" class="nav-link <?= $is_guest_user ? 'nav-link-guest-info' : '' ?>" data-view="projects">
                                        <i class="fas fa-folder"></i>
                                        <span>Projects</span>
                                        <?php if ($is_guest_user): ?>
                                            <span class="nav-info-badge"><i class="fas fa-info-circle"></i></span>
                                        <?php endif; ?>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="#" class="nav-link" data-view="categories">
                                        <i class="fas fa-tags"></i>
                                        <span>Categories</span>
                                    </a>
                                </li>
                            </ul>
                        </div>
                        
                        <div class="nav-divider"></div>
                        
                        <!-- Insights Section -->
                        <div class="nav-section">
                            <div class="nav-section-label">Insights</div>
                            <ul class="nav-list">
                                <li class="nav-item">
                                    <a href="#" class="nav-link <?= $is_guest_user ? 'nav-link-disabled' : '' ?>" data-view="achievements" <?= $is_guest_user ? 'data-guest-restricted="true"' : '' ?>>
                                        <i class="fas fa-trophy"></i>
                                        <span>Achievements</span>
                                        <?php if ($is_guest_user): ?>
                                            <span class="nav-user-badge">[user]</span>
                                        <?php endif; ?>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="#" class="nav-link <?= $is_guest_user ? 'nav-link-disabled' : '' ?>" data-view="calendar" <?= $is_guest_user ? 'data-guest-restricted="true"' : '' ?>>
                                        <i class="fas fa-calendar"></i>
                                        <span>Calendar</span>
                                        <?php if ($is_guest_user): ?>
                                            <span class="nav-user-badge">[user]</span>
                                        <?php endif; ?>
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a href="#" class="nav-link <?= $is_guest_user ? 'nav-link-disabled' : '' ?>" data-view="analytics" <?= $is_guest_user ? 'data-guest-restricted="true"' : '' ?>>
                                        <i class="fas fa-chart-bar"></i>
                                        <span>Analytics</span>
                                        <?php if ($is_guest_user): ?>
                                            <span class="nav-user-badge">[user]</span>
                                        <?php endif; ?>
                                    </a>
                                </li>
                            </ul>
                        </div>
                        
                        <div class="nav-divider"></div>
                        
                        <!-- User Section -->
                        <div class="nav-section">
                            <div class="nav-section-label">User</div>
                            <ul class="nav-list">
                                <li class="nav-item">
                                    <a href="#" class="nav-link <?= $is_guest_user ? 'nav-link-disabled' : '' ?>" data-view="accountsettings" <?= $is_guest_user ? 'data-guest-restricted="true"' : '' ?>>
                                        <i class="fas fa-user-cog"></i>
                                        <span>Account & Settings</span>
                                        <?php if ($is_guest_user): ?>
                                            <span class="nav-user-badge">[user]</span>
                                        <?php endif; ?>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </nav>
                </aside>

                <!-- Main Content -->
                <main class="main-content" id="main-content">
                    <div class="content-header" id="content-header">
                        <!-- Title + Primary Action Row -->
                        <div class="content-header-row title-row">
                            <h2 class="content-title" id="content-title">Dashboard</h2>
                            <div id="content-primary-action">
                                <!-- Primary action button (New Task/Project/Category) -->
                            </div>
                        </div>
                        
                        <!-- Sub-navigation Row (tabs for multi-section views) -->
                        <div class="content-header-row subnav-row" id="content-subnav" style="display: none;">
                            <!-- Tabs (account settings, analytics, etc) -->
                        </div>
                        
                        <!-- Filters Row -->
                        <div class="content-header-row filters-row" id="content-filters-row">
                            <button id="filter-toggle" class="filter-toggle-btn">
                                <i class="fas fa-filter"></i>
                                <span>Advanced Filters</span>
                                <i class="fas fa-chevron-down filter-arrow"></i>
                            </button>
                            <div id="filter-banner-container">
                                <!-- Active filter tags will be shown here -->
                            </div>
                        </div>
                        <div id="filter-panel" class="filter-panel" style="display: none;">
                            <!-- Advanced filter checkboxes will be generated here -->
                        </div>
                        
                        <!-- Sort Row -->
                        <div class="content-header-row sort-row" id="content-sort-row" style="display: none;">
                            <!-- Sort dropdowns -->
                        </div>
                        
                        <!-- Quick Actions Row -->
                        <div class="content-header-row quick-actions-row" id="content-quick-actions" style="display: none;">
                            <!-- Quick action buttons -->
                        </div>
                        
                        <!-- Quick Stats Row -->
                        <div class="content-header-row quick-stats-row" id="content-quick-stats" style="display: none;">
                            <!-- Quick stats/metrics -->
                        </div>
                        
                        <!-- Legacy Actions Row (backward compatibility) -->
                        <div class="content-header-row actions-row">
                            <div class="content-actions" id="content-actions">
                                <!-- Dynamic content actions -->
                            </div>
                        </div>
                    </div>
                    
                    <div class="content-body" id="content-body">
                        <!-- Dynamic content will be rendered here -->
                        <div class="content-placeholder">
                            <div class="placeholder-icon">
                                <i class="fas fa-spinner fa-spin"></i>
                            </div>
                            <h3>Loading...</h3>
                            <p>Please wait while we set up your workspace.</p>
                        </div>
                    </div>
                </main>
            </div>
        </div>

        <!-- Task Modal -->
        <div id="task-modal" class="modal" style="display: none;">
            <div class="modal-content">
                <div class="modal-header">
                    <h2 id="task-modal-title">Add Task</h2>
                    <div class="modal-header-actions">
                        <button type="button" class="btn btn-sm btn-primary" id="task-mode-toggle" style="display: none;">
                            <i class="fas fa-edit"></i> Edit
                        </button>
                        <button class="modal-close" data-modal="task-modal">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>
                <div class="modal-body">
                    <!-- VIEW MODE -->
                    <div id="task-view-mode" style="display: none;">
                        <div class="task-view-header">
                            <h3 id="task-view-title" class="task-view-title"></h3>
                            <span id="task-view-status" class="task-status-badge"></span>
                        </div>

                        <div class="task-view-field">
                            <label class="task-view-label">Description:</label>
                            <span id="task-view-description" class="task-view-value"></span>
                        </div>

                        <div class="task-view-field">
                            <label class="task-view-label">Project:</label>
                            <span id="task-view-project" class="task-view-value"></span>
                            <label class="task-view-label">Category:</label>
                            <span id="task-view-category" class="task-view-value"></span>
                        </div>

                        <div class="task-view-field">
                            <label class="task-view-label">Priority:</label>
                            <span id="task-view-priority" class="priority-badge"></span>
                            <label class="task-view-label">Complexity:</label>
                            <span id="task-view-complexity" class="complexity-badge"></span>
                        </div>

                        <div class="task-view-field">
                            <label class="task-view-label">Due Date:</label>
                            <span id="task-view-due-date" class="task-view-value"></span>
                        </div>

                        <!-- Subtasks in View Mode -->
                        <div id="task-view-subtasks" class="task-view-subtasks-section" style="display: none;">
                            <label class="task-view-label">Steps / Subtasks:</label>
                            <div class="subtasks-progress" id="task-view-subtasks-progress">
                                <div class="progress-bar">
                                    <div class="progress-fill" id="task-view-progress-bar"></div>
                                </div>
                                <span class="progress-text" id="task-view-progress-text">0 / 0 completed</span>
                            </div>
                            <ul class="subtasks-view-list" id="task-view-subtasks-list">
                                <!-- Subtasks will be displayed here -->
                            </ul>
                        </div>
                    </div>

                    <!-- EDIT MODE -->
                    <form id="task-form">
                        <input type="hidden" id="task-id" name="id">
                        
                        <div class="form-group">
                            <label for="task-title">Task Title</label>
                            <input type="text" id="task-title" name="title" required maxlength="255">
                        </div>
                        
                        <div class="form-group">
                            <label for="task-description">Description</label>
                            <textarea id="task-description" name="description" rows="3"></textarea>
                        </div>
                        
                        <div class="form-row">
                            <div class="form-group">
                                <label for="task-project">Project</label>
                                <select id="task-project" name="project_id" required>
                                    <option value="">Select Project</option>
                                </select>
                            </div>
                            
                            <div class="form-group">
                                <label for="task-category">Category</label>
                                <select id="task-category" name="category_id" required>
                                    <option value="">Select Category</option>
                                </select>
                            </div>
                        </div>
                        
                        <div class="form-row">
                            <div class="form-group">
                                <label for="task-priority">Priority</label>
                                <select id="task-priority" name="priority">
                                    <option value="low">Low</option>
                                    <option value="medium" selected>Medium</option>
                                    <option value="high">High</option>
                                    <option value="urgent">Urgent</option>
                                </select>
                            </div>
                            
                            <div class="form-group">
                                <label for="task-complexity">Complexity</label>
                                <select id="task-complexity" name="complexity">
                                    <option value="none" selected>None</option>
                                    <option value="simple">Simple</option>
                                    <option value="moderate">Moderate</option>
                                    <option value="complex">Complex</option>
                                    <option value="very_complex">Very Complex</option>
                                </select>
                            </div>
                        </div>
                        
                        <div class="form-row">
                            <div class="form-group">
                                <label for="task-due-date">Due Date</label>
                                <input type="date" id="task-due-date" name="due_date">
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label>Quick Duration</label>
                            <div class="duration-buttons">
                                <button type="button" class="btn btn-outline duration-btn" data-days="10">10 Days</button>
                                <button type="button" class="btn btn-outline duration-btn" data-days="30">30 Days</button>
                                <button type="button" class="btn btn-outline duration-btn" data-days="90">90 Days</button>
                            </div>
                        </div>
                        
                        <!-- Subtasks Section (only shown when editing) -->
                        <div id="subtasks-section" class="form-group" style="display: none;">
                            <label>Steps / Subtasks</label>
                            <div class="subtasks-progress" id="subtasks-progress" style="display: none;">
                                <div class="progress-bar">
                                    <div class="progress-fill" id="subtasks-progress-bar"></div>
                                </div>
                                <span class="progress-text" id="subtasks-progress-text">0 / 0 completed</span>
                            </div>
                            <ul class="subtasks-list" id="subtasks-list">
                                <!-- Subtasks will be dynamically loaded here -->
                            </ul>
                            <div class="add-subtask-form">
                                <input type="text" id="new-subtask-input" placeholder="Add a step..." maxlength="255">
                                <button type="button" class="btn btn-sm btn-primary" id="add-subtask-btn">
                                    <i class="fas fa-plus"></i> Add Step
                                </button>
                            </div>
                        </div>

                        <!-- Task Suggestions -->
                        <button type="button" class="suggestions-toggle" id="suggestions-toggle" style="display: none;">
                            <i class="fas fa-lightbulb"></i>
                            <span>Smart Suggestions</span>
                            <i class="fas fa-chevron-down"></i>
                        </button>
                        <div id="task-suggestions-container" style="display: none;">
                            <!-- Suggestions will be rendered here -->
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <!-- View Mode Actions -->
                    <div id="task-view-actions" style="display: none;">
                        <button type="button" class="btn btn-danger" id="task-view-delete">
                            <i class="fas fa-trash"></i> Delete
                        </button>
                        <button type="button" class="btn btn-success" id="task-view-complete">
                            <i class="fas fa-check"></i> <span id="task-complete-text">Complete Task</span>
                        </button>
                    </div>
                    <!-- Edit Mode Actions -->
                    <div id="task-edit-actions">
                        <button type="button" class="btn btn-secondary" id="task-edit-cancel" data-modal="task-modal">Cancel</button>
                        <button type="submit" form="task-form" class="btn btn-primary" id="task-submit-btn">Save Task</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Event Modal -->
        <div id="event-modal" class="modal" style="display: none;">
            <div class="modal-content">
                <div class="modal-header">
                    <h2 id="event-modal-title">Add Event</h2>
                    <button class="modal-close" data-modal="event-modal">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="event-form">
                        <input type="hidden" id="event-id" name="id">
                        
                        <div class="form-group">
                            <label for="event-title">Event Title *</label>
                            <input type="text" id="event-title" name="title" required maxlength="255" placeholder="Team meeting">
                        </div>
                        
                        <div class="form-row">
                            <div class="form-group">
                                <label for="event-date">Date *</label>
                                <input type="date" id="event-date" name="event_date" required>
                            </div>
                            
                            <div class="form-group">
                                <label for="event-time">Start Time</label>
                                <input type="time" id="event-time" name="event_time">
                            </div>
                            
                            <div class="form-group">
                                <label for="event-end-time">End Time</label>
                                <input type="time" id="event-end-time" name="end_time">
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label>
                                <input type="checkbox" id="event-all-day" name="is_all_day">
                                All Day Event
                            </label>
                        </div>
                        
                        <div class="form-group">
                            <label for="event-description">Description</label>
                            <textarea id="event-description" name="description" rows="3" placeholder="Event details..."></textarea>
                        </div>
                        
                        <div class="form-group">
                            <label for="event-location">Location</label>
                            <input type="text" id="event-location" name="location" maxlength="255" placeholder="Conference Room A">
                        </div>
                        
                        <div class="form-row">
                            <div class="form-group">
                                <label for="event-color">Color</label>
                                <select id="event-color" name="color">
                                    <option value="#3b82f6">Blue</option>
                                    <option value="#ef4444">Red</option>
                                    <option value="#f97316">Orange</option>
                                    <option value="#eab308">Yellow</option>
                                    <option value="#22c55e">Green</option>
                                    <option value="#6366f1">Indigo</option>
                                    <option value="#a855f7">Purple</option>
                                    <option value="#ec4899">Pink</option>
                                </select>
                            </div>
                            
                            <div class="form-group">
                                <label for="event-reminder">Reminder (minutes before)</label>
                                <input type="number" id="event-reminder" name="reminder_minutes" min="0" step="5" placeholder="15">
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-modal="event-modal">Cancel</button>
                    <button type="submit" form="event-form" class="btn btn-primary" id="event-submit-btn">Save Event</button>
                </div>
            </div>
        </div>

        <!-- Project Modal -->
        <div id="project-modal" class="modal" style="display: none;">
            <div class="modal-content">
                <div class="modal-header">
                    <h2 id="project-modal-title">Add Project</h2>
                    <button class="modal-close" data-modal="project-modal">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="project-form">
                        <input type="hidden" id="project-id">
                        
                        <div class="form-group">
                            <label for="project-name">Project Name</label>
                            <input type="text" id="project-name" name="name" required maxlength="255">
                        </div>
                        
                        <div class="form-group">
                            <label for="project-description">Description</label>
                            <textarea id="project-description" name="description" rows="3"></textarea>
                        </div>
                        
                        <div class="form-group">
                            <label for="project-color">Color</label>
                            <div class="color-picker">
                                <input type="color" id="project-color" name="color" value="#3498db">
                                <div class="color-presets">
                                    <button type="button" class="color-preset" data-color="#3498db"></button>
                                    <button type="button" class="color-preset" data-color="#e74c3c"></button>
                                    <button type="button" class="color-preset" data-color="#2ecc71"></button>
                                    <button type="button" class="color-preset" data-color="#f39c12"></button>
                                    <button type="button" class="color-preset" data-color="#9b59b6"></button>
                                    <button type="button" class="color-preset" data-color="#1abc9c"></button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-modal="project-modal">Cancel</button>
                    <button type="submit" form="project-form" class="btn btn-primary" id="project-submit-btn">Save Project</button>
                </div>
            </div>
        </div>

        <!-- Project Categories Modal -->
        <div id="project-categories-modal" class="modal" style="display: none;">
            <div class="modal-content">
                <div class="modal-header">
                    <h2 id="project-categories-modal-title">Manage Project Categories</h2>
                    <button class="modal-close" data-modal="project-categories-modal">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="project-info">
                        <h3 id="selected-project-name">Project Name</h3>
                        <p class="text-muted">Select categories to bind to this project</p>
                    </div>
                    
                    <div class="categories-list" id="project-categories-list">
                        <!-- Categories will be dynamically populated -->
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-modal="project-categories-modal">Cancel</button>
                    <button type="button" class="btn btn-primary" id="save-project-categories">Save Categories</button>
                </div>
            </div>
        </div>

        <!-- Delete Category Confirmation Modal -->
        <div id="delete-category-modal" class="modal" style="display: none;">
            <div class="modal-content">
                <div class="modal-header">
                    <h2>Delete Category</h2>
                    <button class="modal-close" data-modal="delete-category-modal">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="warning-icon">
                        <i class="fas fa-exclamation-triangle"></i>
                    </div>
                    <h3>Are you sure?</h3>
                    <p>You're about to delete the category "<strong id="category-name-to-delete"></strong>". This action cannot be undone.</p>
                    <p class="text-muted">All tasks in this category will become uncategorized.</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-modal="delete-category-modal">Cancel</button>
                    <button type="button" class="btn btn-danger" id="confirm-delete-category">Delete Category</button>
                </div>
            </div>
        </div>

        <!-- Share Project Modal -->
        <div id="share-modal" class="modal" style="display: none;">
            <div class="modal-content modal-lg">
                <div class="modal-header share-modal-header">
                    <div class="modal-header-content">
                        <h2><i class="fas fa-share-nodes"></i> <?= $is_guest_user ? 'Share Information' : 'Share Project' ?></h2>
                        <div class="modal-subtitle" id="share-project-name">Project Name</div>
                    </div>
                    <button class="modal-close" data-modal="share-modal">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
                <div class="modal-body share-modal-body">
                    
                    <?php if ($is_guest_user): ?>
                    <!-- Guest User Share Information -->
                    <div class="guest-share-info">
                        <div class="share-section">
                            <div class="share-section-header">
                                <i class="fas fa-info-circle"></i>
                                <h3>About This Shared Project</h3>
                            </div>
                            
                            <div class="share-info-card">
                                <div class="share-info-row">
                                    <div class="share-info-label">
                                        <i class="fas fa-folder"></i>
                                        <span>Project</span>
                                    </div>
                                    <div class="share-info-value" id="guest-share-project-name"><?= htmlspecialchars($share_project_name) ?></div>
                                </div>
                                
                                <div class="share-info-row">
                                    <div class="share-info-label">
                                        <i class="fas fa-shield-alt"></i>
                                        <span>Your Permission</span>
                                    </div>
                                    <div class="share-info-value">
                                        <span class="permission-badge <?= $share_permission ?>">
                                            <i class="fas fa-<?= $share_permission === 'edit' ? 'edit' : 'eye' ?>"></i>
                                            <?= $share_permission === 'edit' ? 'Can Edit Tasks' : 'View Only' ?>
                                        </span>
                                    </div>
                                </div>
                                
                                <div class="share-info-row">
                                    <div class="share-info-label">
                                        <i class="fas fa-calendar-alt"></i>
                                        <span>Accessed On</span>
                                    </div>
                                    <div class="share-info-value" id="guest-access-date"><?= date('F j, Y') ?></div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="share-section">
                            <div class="share-section-header">
                                <i class="fas fa-user-plus"></i>
                                <h3>Want Full Access?</h3>
                            </div>
                            <p class="share-section-description">Create a free account to unlock all features including your own projects, achievements, analytics, and more!</p>
                            <a href="/auth/login.php?redirect=<?= urlencode($_SERVER['REQUEST_URI']) ?>" class="btn btn-primary btn-block">
                                <i class="fas fa-user-circle"></i> Create Account or Sign In
                            </a>
                        </div>
                    </div>
                    <?php else: ?>
                    <!-- Regular User Share Controls -->
                    <div class="share-tabs">
                        <button class="share-tab active" data-tab="public-links">
                            <i class="fas fa-link"></i>
                            <span>Share Links</span>
                        </button>
                        <button class="share-tab" data-tab="collaborators">
                            <i class="fas fa-users"></i>
                            <span>Collaborators</span>
                        </button>
                    </div>
                    
                    <!-- Public Links Tab (Now First) -->
                    <div id="public-links-tab" class="share-tab-content active">
                        <!-- Generate Link Section -->
                        <div class="share-section">
                            <div class="share-section-header">
                                <i class="fas fa-plus-circle"></i>
                                <h3>Create Share Link</h3>
                            </div>
                            <p class="share-section-description">Generate a link that anyone can use to access this project</p>
                            
                            <div class="share-form">
                                <div class="form-group">
                                    <label for="link-name">
                                        <i class="fas fa-tag"></i> Link Name <span class="optional">(Optional)</span>
                                    </label>
                                    <input type="text" id="link-name" class="form-control" placeholder="e.g., Team Access, Client Review">
                                </div>
                                
                                <div class="form-row">
                                    <div class="form-group">
                                        <label for="link-permission">
                                            <i class="fas fa-shield-alt"></i> Permission
                                        </label>
                                        <select id="link-permission" class="form-control">
                                            <option value="view">👁️ View Only</option>
                                            <option value="edit">✏️ Can Edit</option>
                                        </select>
                                    </div>
                                    
                                    <div class="form-group">
                                        <label for="link-expiration">
                                            <i class="fas fa-clock"></i> Expires
                                        </label>
                                        <select id="link-expiration" class="form-control">
                                            <option value="">∞ Never</option>
                                            <option value="1">1 Day</option>
                                            <option value="7">7 Days</option>
                                            <option value="30">30 Days</option>
                                            <option value="90">90 Days</option>
                                        </select>
                                    </div>
                                </div>
                                
                                <button type="button" class="btn btn-primary btn-block" id="generate-link-btn">
                                    <i class="fas fa-magic"></i> Generate Link
                                </button>
                            </div>
                        </div>
                        
                        <!-- Active Links Section -->
                        <div class="share-section">
                            <div class="share-section-header">
                                <div class="share-section-title">
                                    <i class="fas fa-list"></i>
                                    <h3>Active Links</h3>
                                    <span class="badge" id="link-count-badge">0</span>
                                </div>
                            </div>
                            
                            <div id="public-links-list" class="share-links-list">
                                <div class="empty-state" id="public-links-empty">
                                    <i class="fas fa-link-slash"></i>
                                    <h4>No active links</h4>
                                    <p>Generate a link above to start sharing</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Collaborators Tab (Now Second) -->
                    <div id="collaborators-tab" class="share-tab-content" style="display: none;">
                        <!-- Search Section -->
                        <div class="share-section">
                            <div class="share-section-header">
                                <i class="fas fa-user-plus"></i>
                                <h3>Invite People</h3>
                            </div>
                            <p class="share-section-description">Search and invite specific users to collaborate</p>
                            
                            <div class="user-search-container">
                                <div class="search-input-wrapper">
                                    <i class="fas fa-search"></i>
                                    <input 
                                        type="text" 
                                        id="user-search-input" 
                                        class="form-control"
                                        placeholder="Search by username, email, or name..."
                                        autocomplete="off">
                                </div>
                                <div id="user-search-results" class="user-search-results" style="display: none;"></div>
                            </div>
                        </div>
                        
                        <!-- Collaborators List Section -->
                        <div class="share-section">
                            <div class="share-section-header">
                                <div class="share-section-title">
                                    <i class="fas fa-users"></i>
                                    <h3>Current Collaborators</h3>
                                </div>
                            </div>
                            
                            <div id="collaborators-list" class="collaborators-list">
                                <div class="empty-state" id="collaborators-empty">
                                    <i class="fas fa-users-slash"></i>
                                    <h4>No collaborators yet</h4>
                                    <p>Search above to add team members</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-modal="share-modal">
                        Close
                    </button>
                </div>
            </div>
        </div>

        <!-- Add Category Modal -->
        <div id="category-modal" class="modal" style="display: none;">
            <div class="modal-content">
                <div class="modal-header">
                    <h2 id="category-modal-title">Add Category</h2>
                    <button class="modal-close" data-modal="category-modal">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
                <form id="category-form">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="category-name">Category Name *</label>
                            <input type="text" id="category-name" name="name" required placeholder="e.g., Personal, Work, Urgent">
                        </div>
                        
                        <div class="form-group">
                            <label for="category-description">Description</label>
                            <textarea id="category-description" name="description" placeholder="Brief description of this category" rows="3"></textarea>
                        </div>
                        
                        <div class="form-group">
                            <label for="category-color">Color</label>
                            <div class="color-picker">
                                <input type="color" id="category-color" name="color" value="#2563eb">
                                <div class="color-presets">
                                    <button type="button" class="color-preset" data-color="#2563eb" style="background: #2563eb" title="Blue"></button>
                                    <button type="button" class="color-preset" data-color="#dc2626" style="background: #dc2626" title="Red"></button>
                                    <button type="button" class="color-preset" data-color="#16a34a" style="background: #16a34a" title="Green"></button>
                                    <button type="button" class="color-preset" data-color="#ca8a04" style="background: #ca8a04" title="Yellow"></button>
                                    <button type="button" class="color-preset" data-color="#9333ea" style="background: #9333ea" title="Purple"></button>
                                    <button type="button" class="color-preset" data-color="#ea580c" style="background: #ea580c" title="Orange"></button>
                                    <button type="button" class="color-preset" data-color="#0891b2" style="background: #0891b2" title="Cyan"></button>
                                    <button type="button" class="color-preset" data-color="#be185d" style="background: #be185d" title="Pink"></button>
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <div class="checkbox-group">
                                <label for="category-auto-bind" class="checkbox-label">
                                    <input type="checkbox" id="category-auto-bind" name="auto_bind">
                                    <span class="checkbox-custom"></span>
                                    <div class="checkbox-info">
                                        <span class="checkbox-title">Always bind to new projects</span>
                                        <span class="checkbox-description">Automatically add this category to any new projects created</span>
                                    </div>
                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-modal="category-modal">Cancel</button>
                        <button type="submit" class="btn btn-primary" id="save-category">
                            <span class="btn-text">
                                <i class="fas fa-save"></i> Save Category
                            </span>
                            <span class="btn-loading" style="display: none;">
                                <i class="fas fa-spinner fa-spin"></i> Saving...
                            </span>
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <!-- Category Project Binding Modal -->
        <div id="category-binding-modal" class="modal" style="display: none;">
            <div class="modal-content modal-lg">
                <div class="modal-header">
                    <h2>Manage Category Projects</h2>
                    <button class="modal-close" data-modal="category-binding-modal">
                        <i class="fas fa-times"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="binding-header">
                        <div class="category-info">
                            <div class="category-color-indicator" id="binding-category-color"></div>
                            <div>
                                <h3 id="binding-category-name"></h3>
                                <p id="binding-category-description"></p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="projects-grid">
                        <h4>Select Projects for this Category:</h4>
                        <div id="binding-projects-list" class="checkbox-list">
                            <!-- Projects will be populated by JavaScript -->
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-modal="category-binding-modal">Cancel</button>
                    <button type="button" class="btn btn-primary" id="save-category-bindings">
                        <span class="btn-text">
                            <i class="fas fa-save"></i> Update Bindings
                        </span>
                        <span class="btn-loading" style="display: none;">
                            <i class="fas fa-spinner fa-spin"></i> Updating...
                        </span>
                    </button>
                </div>
            </div>
        </div>

        <!-- Settings Page Template (Hidden, will be rendered by JavaScript) -->
        <template id="settings-page-template">
            <div class="settings-page">
                <div class="settings-header">
                    <h2><i class="fas fa-cog"></i> Settings</h2>
                    <p class="settings-subtitle">Customize your TaskManager experience</p>
                </div>
                <div class="settings-container">
                    <div class="settings-tabs">
                        <button class="settings-tab active" data-tab="general">
                            <i class="fas fa-cog"></i> General
                        </button>
                        <button class="settings-tab" data-tab="appearance">
                            <i class="fas fa-palette"></i> Display
                        </button>
                        <button class="settings-tab" data-tab="notifications">
                            <i class="fas fa-bell"></i> Notifications
                        </button>
                    </div>
                    
                    <div class="settings-content">
                        <!-- General Settings -->
                        <div class="settings-panel active" id="general-settings">
                            <h3>General Settings</h3>
                            
                            <div class="setting-group">
                                <label for="default-due-days">Default Due Date (Days)</label>
                                <select id="default-due-days">
                                    <option value="1">Tomorrow (1 day)</option>
                                    <option value="7">1 Week</option>
                                    <option value="14">2 Weeks</option>
                                    <option value="30">1 Month</option>
                                </select>
                            </div>
                            
                            <div class="setting-group">
                                <label for="tasks-per-page">Tasks Per Page</label>
                                <select id="tasks-per-page">
                                    <option value="10">10</option>
                                    <option value="25" selected>25</option>
                                    <option value="50">50</option>
                                    <option value="100">100</option>
                                </select>
                            </div>
                            
                            <div class="setting-group">
                                <label class="checkbox-label">
                                    <input type="checkbox" id="auto-save">
                                    <span class="checkmark"></span>
                                    Auto-save changes
                                </label>
                            </div>
                            
                            <div class="setting-group">
                                <label class="checkbox-label">
                                    <input type="checkbox" id="use-last-project" checked>
                                    <span class="checkmark"></span>
                                    Use last selected project for new tasks
                                </label>
                            </div>
                            
                            <div class="setting-group">
                                <label class="checkbox-label">
                                    <input type="checkbox" id="use-last-category" checked>
                                    <span class="checkmark"></span>
                                    Use last selected category for new tasks
                                </label>
                            </div>
                            
                            <div class="setting-group">
                                <label for="default-task-view">Default Task View</label>
                                <select id="default-task-view">
                                    <option value="list" selected>List View</option>
                                    <option value="kanban">Kanban Board</option>
                                    <option value="calendar">Calendar View</option>
                                </select>
                                <small class="setting-description">Choose which view to show when opening TaskManager
                                </small>
                            </div>
                            
                            <div class="setting-group">
                                <label for="auto-archive-days">Auto-archive Completed Tasks</label>
                                <select id="auto-archive-days">
                                    <option value="0">Never</option>
                                    <option value="7">After 7 days</option>
                                    <option value="14">After 14 days</option>
                                    <option value="30" selected>After 30 days</option>
                                    <option value="90">After 90 days</option>
                                </select>
                                <small class="setting-description">Automatically archive completed tasks after the specified period</small>
                            </div>
                        </div>
                        
                        <!-- Appearance Settings -->
                        <div class="settings-panel" id="appearance-settings">
                            <h3>Appearance</h3>
                            
                            <div class="setting-group">
                                <label for="font-size">Font Size</label>
                                <select id="font-size">
                                    <option value="small">Small</option>
                                    <option value="medium" selected>Medium</option>
                                    <option value="large">Large</option>
                                </select>
                            </div>
                            
                            <div class="setting-group">
                                <label class="checkbox-label">
                                    <input type="checkbox" id="reduced-motion">
                                    <span class="checkmark"></span>
                                    Reduce animations
                                </label>
                            </div>
                            
                            <div class="setting-info">
                                <p class="text-muted">
                                    <i class="fas fa-info-circle"></i>
                                    Theme settings can be changed from your <a href="/account/#tab=preferences">Account Preferences</a>.
                                </p>
                            </div>
                        </div>
                        
                        <!-- Notification Settings -->
                        <div class="settings-panel" id="notifications-settings">
                            <h3>Notifications</h3>
                            
                            <div class="setting-group">
                                <label class="checkbox-label">
                                    <input type="checkbox" id="browser-notifications" checked>
                                    <span class="checkmark"></span>
                                    Browser notifications
                                </label>
                            </div>
                            
                            <div class="setting-group">
                                <label class="checkbox-label">
                                    <input type="checkbox" id="task-reminders" checked>
                                    <span class="checkmark"></span>
                                    Task due date reminders
                                </label>
                            </div>
                            
                            <div class="setting-group">
                                <label for="reminder-time">Reminder Time</label>
                                <select id="reminder-time">
                                    <option value="15">15 minutes before</option>
                                    <option value="30">30 minutes before</option>
                                    <option value="60" selected>1 hour before</option>
                                    <option value="1440">1 day before</option>
                                </select>
                            </div>
                            
                            <div class="setting-group">
                                <label class="checkbox-label">
                                    <input type="checkbox" id="sound-notifications">
                                    <span class="checkmark"></span>
                                    Sound notifications
                                </label>
                            </div>
                            
                            <div class="setting-group">
                                <label class="checkbox-label">
                                    <input type="checkbox" id="show-completed-in-search">
                                    <span class="checkmark"></span>
                                    Show completed items in search
                                </label>
                                <small class="setting-description">Include completed tasks in search results</small>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="settings-actions">
                    <button type="button" class="btn btn-outline" id="reset-settings">Reset to Defaults</button>
                    <button type="button" class="btn btn-primary" id="save-settings">
                        <i class="fas fa-save"></i> Save Settings
                    </button>
                </div>
            </div>
        </template>

        <!-- Notifications -->
        <div id="notification-container" class="notification-container"></div>
        
        <!-- Developer Task Bar -->
        <div id="dev-bar" class="dev-bar" style="display: none;">
            <div class="dev-bar-header">
                <span class="dev-bar-title">
                    <i class="fas fa-code"></i> Developer Tools
                </span>
                <button class="dev-bar-toggle-btn" onclick="app.toggleDevBar()" title="Close Dev Bar">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            
            <!-- Tab Navigation -->
            <div class="dev-tabs">
                <button class="dev-tab active" data-tab="general" onclick="app.devTools.switchTab('general')">
                    <i class="fas fa-cog"></i> General
                </button>
                <button class="dev-tab" data-tab="achievements" onclick="app.devTools.switchTab('achievements')">
                    <i class="fas fa-trophy"></i> Achievements
                </button>
                <button class="dev-tab" data-tab="testing" onclick="app.devTools.switchTab('testing')">
                    <i class="fas fa-flask"></i> Testing
                </button>
            </div>
            
            <div class="dev-bar-content">
                <!-- General Tab -->
                <div class="dev-tab-content active" id="dev-tab-general">
                <div class="dev-bar-section">
                    <h4>Quick Stats</h4>
                    <div class="dev-stats">
                        <div class="dev-stat">
                            <span class="dev-stat-label">Tasks:</span>
                            <span class="dev-stat-value" id="dev-tasks-count">0</span>
                            <span class="dev-stat-sublabel" id="dev-test-tasks-count">/ 0 test</span>
                        </div>
                        <div class="dev-stat">
                            <span class="dev-stat-label">Projects:</span>
                            <span class="dev-stat-value" id="dev-projects-count">0</span>
                            <span class="dev-stat-sublabel" id="dev-test-projects-count">/ 0 test</span>
                        </div>
                        <div class="dev-stat">
                            <span class="dev-stat-label">Categories:</span>
                            <span class="dev-stat-value" id="dev-categories-count">0</span>
                        </div>
                        <div class="dev-stat">
                            <span class="dev-stat-label">XP:</span>
                            <span class="dev-stat-value" id="dev-xp-total">0</span>
                        </div>
                        <div class="dev-stat">
                            <span class="dev-stat-label">Level:</span>
                            <span class="dev-stat-value" id="dev-level">1</span>
                        </div>
                        <div class="dev-stat">
                            <span class="dev-stat-label">User:</span>
                            <span class="dev-stat-value" id="dev-username">-</span>
                        </div>
                    </div>
                    <div class="dev-stats" id="dev-cache-stats" style="margin-top: 8px; font-size: 11px; opacity: 0.8;">
                        <strong>Cache:</strong> Loading...
                    </div>
                </div>
                <div class="dev-bar-section">
                    <h4>Actions</h4>
                    <div class="dev-actions">
                        <button class="btn-dev" onclick="app.devTools.viewState()">
                            <i class="fas fa-database"></i> View State
                        </button>
                        <button class="btn-dev" onclick="app.devTools.clearCache()">
                            <i class="fas fa-trash"></i> Clear Cache
                        </button>
                        <button class="btn-dev" onclick="app.devTools.testAPI()">
                            <i class="fas fa-plug"></i> Test API
                        </button>
                        <button class="btn-dev" onclick="app.devTools.exportData()">
                            <i class="fas fa-download"></i> Export Data
                        </button>
                        <button class="btn-dev" onclick="app.devTools.openConsole()">
                            <i class="fas fa-terminal"></i> Console
                        </button>
                        <button class="btn-dev" onclick="app.devTools.reloadData()">
                            <i class="fas fa-sync"></i> Reload Data
                        </button>
                        <button class="btn-dev" onclick="app.devTools.resetOnboarding()" style="border-color: rgba(16, 185, 129, 0.3); color: #10b981;">
                            <i class="fas fa-graduation-cap"></i> Reset Onboarding
                        </button>
                        <button class="btn-dev" onclick="app.devTools.removeOnboarding()" style="border-color: rgba(239, 68, 68, 0.3); color: #ef4444;">
                            <i class="fas fa-trash-alt"></i> Remove Onboarding
                        </button>
                    </div>
                </div>
                </div>
                
                <!-- Achievements Tab -->
                <div class="dev-tab-content" id="dev-tab-achievements" style="display: none;">
                    <div class="dev-bar-section">
                        <h4>Achievement Stats Manipulation</h4>
                        <div class="dev-stat-controls">
                            <div class="dev-control-row">
                                <label>Tasks Created:</label>
                                <div class="dev-btn-group">
                                    <button class="btn-dev-sm" onclick="app.devTools.adjustAchievementStat('task_created', 1)">+1</button>
                                    <button class="btn-dev-sm" onclick="app.devTools.adjustAchievementStat('task_created', 10)">+10</button>
                                    <button class="btn-dev-sm" onclick="app.devTools.adjustAchievementStat('task_created', -1)">-1</button>
                                    <input type="number" id="stat-task-created" placeholder="Set" class="dev-input-sm">
                                    <button class="btn-dev-sm" onclick="app.devTools.setAchievementStat('task_created')">Set</button>
                                </div>
                            </div>
                            <div class="dev-control-row">
                                <label>Tasks Completed:</label>
                                <div class="dev-btn-group">
                                    <button class="btn-dev-sm" onclick="app.devTools.adjustAchievementStat('task_completed', 1)">+1</button>
                                    <button class="btn-dev-sm" onclick="app.devTools.adjustAchievementStat('task_completed', 10)">+10</button>
                                    <button class="btn-dev-sm" onclick="app.devTools.adjustAchievementStat('task_completed', -1)">-1</button>
                                    <input type="number" id="stat-task-completed" placeholder="Set" class="dev-input-sm">
                                    <button class="btn-dev-sm" onclick="app.devTools.setAchievementStat('task_completed')">Set</button>
                                </div>
                            </div>
                            <div class="dev-control-row">
                                <label>Projects Created:</label>
                                <div class="dev-btn-group">
                                    <button class="btn-dev-sm" onclick="app.devTools.adjustAchievementStat('project_created', 1)">+1</button>
                                    <button class="btn-dev-sm" onclick="app.devTools.adjustAchievementStat('project_created', 5)">+5</button>
                                    <button class="btn-dev-sm" onclick="app.devTools.adjustAchievementStat('project_created', -1)">-1</button>
                                </div>
                            </div>
                            <div class="dev-control-row">
                                <label>Projects Completed:</label>
                                <div class="dev-btn-group">
                                    <button class="btn-dev-sm" onclick="app.devTools.adjustAchievementStat('project_completed', 1)">+1</button>
                                    <button class="btn-dev-sm" onclick="app.devTools.adjustAchievementStat('project_completed', 5)">+5</button>
                                    <button class="btn-dev-sm" onclick="app.devTools.adjustAchievementStat('project_completed', -1)">-1</button>
                                </div>
                            </div>
                            <div class="dev-control-row">
                                <label>Subtasks:</label>
                                <div class="dev-btn-group">
                                    <button class="btn-dev-sm" onclick="app.devTools.adjustAchievementStat('subtask_created', 1)">+1</button>
                                    <button class="btn-dev-sm" onclick="app.devTools.adjustAchievementStat('subtask_created', 10)">+10</button>
                                    <button class="btn-dev-sm" onclick="app.devTools.adjustAchievementStat('subtask_created', -1)">-1</button>
                                </div>
                            </div>
                            <div class="dev-control-row">
                                <label>Streak Days:</label>
                                <div class="dev-btn-group">
                                    <button class="btn-dev-sm" onclick="app.devTools.adjustAchievementStat('streak_days', 1)">+1</button>
                                    <button class="btn-dev-sm" onclick="app.devTools.adjustAchievementStat('streak_days', 7)">+7</button>
                                    <button class="btn-dev-sm" onclick="app.devTools.adjustAchievementStat('streak_days', -1)">-1</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="dev-bar-section">
                        <h4>Achievement Management</h4>
                        <div class="dev-actions">
                            <button class="btn-dev" onclick="app.devTools.recheckAllAchievements()">
                                <i class="fas fa-sync"></i> Recheck All
                            </button>
                            <button class="btn-dev" onclick="app.devTools.viewAchievements()">
                                <i class="fas fa-list"></i> View All
                            </button>
                            <button class="btn-dev" onclick="app.devTools.resetAchievements()" style="border-color: rgba(239, 68, 68, 0.3); color: #ef4444;">
                                <i class="fas fa-trash"></i> Reset All
                            </button>
                        </div>
                        <div style="margin-top: 12px; display: flex; gap: 6px; align-items: center;">
                            <input type="number" id="achievement-id-input" min="1" max="99" placeholder="Achievement ID" style="width: 120px; padding: 6px 8px; background: rgba(255,255,255,0.05); border: 1px solid rgba(255,255,255,0.1); border-radius: 4px; color: #e5e7eb; font-size: 12px;">
                            <button class="btn-dev" onclick="app.devTools.unlockAchievement()" style="flex: 1; border-color: rgba(34, 197, 94, 0.3); color: #22c55e;">
                                <i class="fas fa-unlock"></i> Unlock
                            </button>
                            <button class="btn-dev" onclick="app.devTools.lockAchievement()" style="flex: 1; border-color: rgba(239, 68, 68, 0.3); color: #ef4444;">
                                <i class="fas fa-lock"></i> Lock
                            </button>
                        </div>
                    </div>
                    
                    <div class="dev-bar-section">
                        <h4>Admin Secret Achievement</h4>
                        <button class="btn-dev" onclick="app.devTools.unlockAdminSecret()" style="width: 100%; margin-bottom: 6px; border-color: rgba(245, 158, 11, 0.3); color: #f59e0b;">
                            <i class="fas fa-crown"></i> Unlock Admin Secret (ID 99)
                        </button>
                        <button class="btn-dev" onclick="app.devTools.lockAdminSecret()" style="width: 100%; border-color: rgba(107, 114, 128, 0.3); color: #9ca3af;">
                            <i class="fas fa-lock"></i> Lock Admin Secret
                        </button>
                    </div>
                </div>
                
                <!-- Testing Tab -->
                <div class="dev-tab-content" id="dev-tab-testing" style="display: none;">
                    <div class="dev-bar-section">
                        <h4>Generate Test Tasks</h4>
                        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 6px; margin-bottom: 8px;">
                            <div>
                                <label style="font-size: 10px; color: #9ca3af; display: block; margin-bottom: 3px;">Count</label>
                                <input type="number" id="gen-task-count" value="10" min="1" max="100" style="width: 100%; padding: 6px 8px; background: rgba(255,255,255,0.05); border: 1px solid rgba(255,255,255,0.1); border-radius: 4px; color: #e5e7eb; font-size: 12px;">
                            </div>
                            <div>
                                <label style="font-size: 10px; color: #9ca3af; display: block; margin-bottom: 3px;">Desc Words</label>
                                <input type="number" id="gen-task-desc-words" value="20" min="0" max="200" placeholder="0=none" style="width: 100%; padding: 6px 8px; background: rgba(255,255,255,0.05); border: 1px solid rgba(255,255,255,0.1); border-radius: 4px; color: #e5e7eb; font-size: 12px;">
                            </div>
                        </div>
                        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 6px; margin-bottom: 8px;">
                            <select id="gen-task-project" style="padding: 6px 8px; background: rgba(255,255,255,0.05); border: 1px solid rgba(255,255,255,0.1); border-radius: 4px; color: #e5e7eb; font-size: 11px;">
                                <option value="random">Random Project</option>
                                <option value="test">[TEST] Project</option>
                            </select>
                            <select id="gen-task-category" style="padding: 6px 8px; background: rgba(255,255,255,0.05); border: 1px solid rgba(255,255,255,0.1); border-radius: 4px; color: #e5e7eb; font-size: 11px;">
                                <option value="random">Random Category</option>
                            </select>
                        </div>
                        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 6px; margin-bottom: 8px;">
                            <select id="gen-task-priority" style="padding: 6px 8px; background: rgba(255,255,255,0.05); border: 1px solid rgba(255,255,255,0.1); border-radius: 4px; color: #e5e7eb; font-size: 11px;">
                                <option value="random">Random Priority</option>
                                <option value="urgent">Urgent</option>
                                <option value="high">High</option>
                                <option value="normal">Normal</option>
                                <option value="low">Low</option>
                            </select>
                            <select id="gen-task-status" style="padding: 6px 8px; background: rgba(255,255,255,0.05); border: 1px solid rgba(255,255,255,0.1); border-radius: 4px; color: #e5e7eb; font-size: 11px;">
                                <option value="pending">Pending</option>
                                <option value="in_progress">In Progress</option>
                                <option value="completed">Completed</option>
                                <option value="random">Random</option>
                            </select>
                        </div>
                        <div style="display: grid; grid-template-columns: 1fr auto; gap: 6px;">
                            <button class="btn-dev" onclick="app.devTools.generateTestTasks()" style="border-color: rgba(59, 130, 246, 0.3); color: #3b82f6;">
                                <i class="fas fa-plus-circle"></i> Generate Test Tasks
                            </button>
                            <button class="btn-dev" onclick="app.devTools.cleanupTestTasks()" style="border-color: rgba(239, 68, 68, 0.3); color: #ef4444;" title="Cleanup Test Tasks">
                                <i class="fas fa-broom"></i>
                            </button>
                        </div>
                    </div>
                    
                    <div class="dev-bar-section">
                        <h4>Generate Test Projects</h4>
                        <div style="margin-bottom: 8px;">
                            <input type="number" id="gen-project-count" value="5" min="1" max="20" style="width: 100%; padding: 6px 8px; background: rgba(255,255,255,0.05); border: 1px solid rgba(255,255,255,0.1); border-radius: 4px; color: #e5e7eb; font-size: 12px;" placeholder="Project Count">
                        </div>
                        <div style="display: grid; grid-template-columns: 1fr auto; gap: 6px;">
                            <button class="btn-dev" onclick="app.devTools.generateTestProjects()" style="border-color: rgba(139, 92, 246, 0.3); color: #8b5cf6;">
                                <i class="fas fa-folder-plus"></i> Generate Test Projects
                            </button>
                            <button class="btn-dev" onclick="app.devTools.cleanupTestProjects()" style="border-color: rgba(239, 68, 68, 0.3); color: #ef4444;" title="Cleanup Test Projects">
                                <i class="fas fa-broom"></i>
                            </button>
                        </div>
                    </div>
                    
                    <div class="dev-bar-section">
                        <h4>Global Cleanup</h4>
                        <button class="btn-dev" onclick="app.devTools.cleanupAllTestData()" style="width: 100%; border-color: rgba(239, 68, 68, 0.5); color: #ef4444; background: rgba(239, 68, 68, 0.1);">
                            <i class="fas fa-trash-alt"></i> Cleanup All Test Data
                        </button>
                    </div>
                    
                    <div class="dev-bar-section">
                        <h4>TEST Stats</h4>
                        <div id="dev-debug-info" style="background: rgba(0,0,0,0.3); padding: 10px; border-radius: 4px; font-family: monospace; font-size: 10px; color: #9ca3af; max-height: 200px; overflow-y: auto;">
                            Click "Update TEST Stats" to see stats
                        </div>
                        <button class="btn-dev" onclick="app.devTools.updateDebugInfo()" style="width: 100%; margin-top: 8px;">
                            <i class="fas fa-info-circle"></i> Update TEST Stats
                        </button>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Dev Bar Trigger Button (always visible for admins) -->
        <button id="dev-bar-trigger" class="dev-bar-trigger" style="display: none;" onclick="app.toggleDevBar()" title="Open Developer Tools">
            <i class="fas fa-code"></i>
        </button>
        
        <!-- FAB (Floating Action Button) -->
        <!-- <button id="fab" class="fab" title="Quick Add Task">
            <i class="fas fa-plus"></i>
        </button> -->
    </div>

    <!-- Pass PHP user data to JavaScript -->
    <script>
        window.BLOODWEB_USER = {
            id: <?php echo $user_id; ?>,
            username: <?php echo json_encode($user['username'] ?? ''); ?>,
            first_name: <?php echo json_encode($user['first_name'] ?? ''); ?>,
            last_name: <?php echo json_encode($user['last_name'] ?? ''); ?>,
            email: <?php echo json_encode($user['email'] ?? ''); ?>,
            role: <?php echo json_encode($user['role'] ?? 'user'); ?>,
            created_at: <?php echo json_encode($user['created_at'] ?? null); ?>
        };
        
        // Legacy support
        const CURRENT_USER = window.BLOODWEB_USER;
    </script>

    <!-- BloodWeb Core Functions -->
    <script src="/shared/assets/keyFunctions.js"></script>
    
    <!-- Application Scripts -->
    <script src="./APICache.js?v=<?php echo time(); ?>"></script>
    <script src="./VirtualScroller.js?v=<?php echo time(); ?>"></script>
    <script src="./SkeletonLoader.js?v=<?php echo time(); ?>"></script>
    <script src="./TaskAssistant.js?v=<?php echo time(); ?>"></script>
    <script src="./CalendarManager.js?v=<?php echo time(); ?>"></script>
    <script src="./CollaborationManager.js?v=<?php echo time(); ?>"></script>
    <script src="./AchievementSystem.js?v=<?php echo time(); ?>"></script>
    <script src="./KeyboardManager.js?v=<?php echo time(); ?>"></script>
    <script src="./BulkActions.js?v=<?php echo time(); ?>"></script>
    <script src="./QuickCapture.js?v=<?php echo time(); ?>"></script>
    <script src="./FocusMode.js?v=<?php echo time(); ?>"></script>
    <script src="./main.js?v=<?php echo time(); ?>"></script>
    
    <!-- PWA Service Worker -->
    <script>
        if ('serviceWorker' in navigator) {
            // Clean up any service workers registered at wrong scope (safety measure)
            navigator.serviceWorker.getRegistrations().then(function(registrations) {
                registrations.forEach(function(registration) {
                    // Only unregister if it's NOT in our intended scope
                    if (!registration.scope.includes('/app/tasklist/') && 
                        !registration.scope.includes('/TaskList/')) {
                        console.log('Unregistering service worker from wrong scope:', registration.scope);
                        registration.unregister();
                    }
                });
            });
            
            // Register service worker with explicit scope limited to /TaskList/ or /app/tasklist/
            navigator.serviceWorker.register('./service-worker.js?v=<?php echo time(); ?>', {
                scope: './'
            })
                .then(function(registration) {
                    console.log('SW registered with scope:', registration.scope);
                })
                .catch(function(registrationError) {
                    console.log('SW registration failed: ', registrationError);
                });
        }
    </script>
</body>
</html>