<?php
// Backend verification script
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "=== BLOODWEB TASKLIST V2 BACKEND VERIFICATION ===\n\n";

// Include our models and database classes
require_once __DIR__ . '/Database.php';
require_once __DIR__ . '/Models.php';

try {
    // Test database connection
    echo "1. Testing Database Connection:\n";
    $db = DatabaseConnection::getInstance();
    echo "   ✓ Database connected successfully\n\n";
    
    // Test projects
    echo "2. Testing Projects:\n";
    $project = new Project($db);
    $projects = $project->all();
    echo "   ✓ Found " . count($projects) . " projects\n\n";
    
    // Test tasks
    echo "3. Testing Tasks:\n";
    $task = new Task($db);
    $tasks = $task->all();
    echo "   ✓ Found " . count($tasks) . " tasks\n\n";
    
    // Test XP system
    echo "4. Testing XP System:\n";
    $xp = new XPLog($db);
    $user = new User($db);
    $totalXP = $xp->getTotalXP(1);
    $userData = $user->find(1);
    if ($userData) {
        echo "   ✓ XP System working - User Level: " . $userData['level_id'] . ", Total XP: " . $userData['xp_total'] . "\n\n";
    } else {
        echo "   ! User data not found for user 1\n\n";
    }
    
    // Test users
    echo "5. Testing Users:\n";
    $user = new User($db);
    $users = $user->all();
    echo "   ✓ Found " . count($users) . " users\n\n";
    
    // Test categories
    echo "6. Testing Categories:\n";
    $category = new Category($db);
    $categories = $category->all();
    echo "   ✓ Found " . count($categories) . " categories\n\n";
    
    echo "=== BACKEND VERIFICATION COMPLETE ===\n";
    echo "All core systems are functional!\n";
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
    echo "Stack trace: " . $e->getTraceAsString() . "\n";
}
?>